<?php

namespace Kitt3n\AzureAdForSymfonyBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('azure_ad_for_symfony');
        $rootNode = $treeBuilder->getRootNode();

        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.

        $rootNode
            ->children()

                ->booleanNode('active')->defaultValue('%env(resolve:AAFS_ACTIVE)%')->end()

                ->arrayNode('oauth')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('client_id')->defaultValue('%env(resolve:AAFS_OAUTH_CLIENT_ID)%')->end()
                        ->scalarNode('client_secret')->defaultValue('%env(resolve:AAFS_OAUTH_CLIENT_SECRET)%')->end()
                        ->scalarNode('tenant')->defaultValue('%env(resolve:AAFS_OAUTH_TENANT)%')->end()
                        ->scalarNode('redirect_uri')->defaultValue('%env(resolve:AAFS_OAUTH_REDIRECT_URI_DOMAIN)%/[[[_locale]]]/sso/azure/ad/process')->end()
                        ->scalarNode('url_authorize')->defaultValue('https://login.microsoftonline.com/%env(resolve:AAFS_OAUTH_TENANT)%/oauth2/v2.0/authorize')->end()
                        ->scalarNode('url_access_token')->defaultValue('https://login.microsoftonline.com/%env(resolve:AAFS_OAUTH_TENANT)%/oauth2/v2.0/token')->end()
                        ->scalarNode('url_resource_owner_details')->defaultValue('')->end()
                        ->scalarNode('scopes')->defaultValue('%env(resolve:AAFS_OAUTH_SCOPES)%')->end()

                        /**
                         * Azure Active Directory / Groups
                         * Priority 1
                         */
                        ->arrayNode('groups')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->scalarNode('admin')->defaultValue('%env(resolve:AAFS_OAUTH_GOUPS_ADMIN)%')->end()
                                ->scalarNode('backend')->defaultValue('%env(resolve:AAFS_OAUTH_GOUPS_BACKEND)%')->end()
                                ->scalarNode('frontend')->defaultValue('%env(resolve:AAFS_OAUTH_GOUPS_FRONTEND)%')->end()
                            ->end()
                        ->end()

                        /**
                         * App Registration / App Roles
                         * Priority 2
                         */
                        ->arrayNode('app_roles')
                            ->children()
                                ->scalarNode('admin')->defaultValue('--')->end()
                                ->scalarNode('backend')->defaultValue('--')->end()
                                ->scalarNode('frontend')->defaultValue('--')->end()
                            ->end()
                        ->end()

                        ->arrayNode('redirect_route')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->scalarNode('success')->defaultValue('%env(resolve:AAFS_OAUTH_REDIRECT_ROUTE_SUCCESS)%')->end()
                            ->end()
                        ->end()

                    ->end()
                ->end()

                ->arrayNode('encryption')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('secret')->defaultValue('%env(resolve:AAFS_ENCRYPTION_SECRET)%')->end()
                    ->end()
                ->end()

            ->end()
            ;

        return $treeBuilder;
    }
}
