<?php 

namespace Kitt3n\AzureAdForSymfonyBundle\Service;

use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

abstract class AbstractService 
{

    /** 
     * General variables 
     */

    private $treeBuilderRootNode = 'azure_ad_for_symfony';
    
    private $parameters = null;

    /** 
     * Cookie variables 
     */

    protected $cookieName = 'kaafs';

    protected $cookieSplitLength = 500;

    public function __construct(
        ParameterBagInterface $parameters
    ) {
        $this->parameters = $parameters;
    }

	/**
	 * 
	 * @return mixed
	 */
	function getTreeBuilderRootNode() {
		return $this->treeBuilderRootNode;
	}
	
	/**
	 * 
	 * @param mixed $treeBuilderRootNode 
	 * @return AbstractService
	 */
	function setTreeBuilderRootNode($treeBuilderRootNode): self {
		$this->treeBuilderRootNode = $treeBuilderRootNode;
		return $this;
	}
	/**
	 * 
	 * @return mixed
	 */
	function getCookieName() {
		return $this->cookieName;
	}
	
	/**
	 * 
	 * @param mixed $cookieName 
	 * @return AbstractService
	 */
	function setCookieName($cookieName): self {
		$this->cookieName = $cookieName;
		return $this;
	}
	/**
	 * 
	 * @return mixed
	 */
	function getCookieSplitLength() {
		return $this->cookieSplitLength;
	}
	
	/**
	 * 
	 * @param mixed $cookieSplitLength 
	 * @return AbstractService
	 */
	function setCookieSplitLength($cookieSplitLength): self {
		$this->cookieSplitLength = $cookieSplitLength;
		return $this;
	}
	/**
	 * 
	 * @return mixed
	 */
	function getParameters() {
		return $this->parameters;
	}
	
	/**
	 * 
	 * @param mixed $parameters 
	 * @return AbstractService
	 */
	function setParameters($parameters): self {
		$this->parameters = $parameters;
		return $this;
	}
}