<?php 

namespace Kitt3n\AzureAdForSymfonyBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\RequestStack;

use Kitt3n\SingleSignOnForSymfonyBundle\Service\CookieService as GenericCookieService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\ConfigService as GenericConfigService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\OauthService as GenericOauthService;
use Kitt3n\SingleSignOnForSymfonyBundle\Controller\SingleSignOnController as GenericSignOnController;

use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService as SpecificConfigService;
use Kitt3n\AzureAdForSymfonyBundle\Service\OauthService as SpecificOauthService;
use Kitt3n\AzureAdForSymfonyBundle\Service\IdentityService as SpecificIdentityService;
use Symfony\Component\HttpFoundation\Request;
use League\OAuth2\Client\Provider\GenericProvider;

use Microsoft\Graph\Graph;
use Microsoft\Graph\Model;
use Microsoft\Graph\Exception;
use Kitt3n\AzureAdForSymfonyBundle\Entity\Identity;
use League\OAuth2\Client\Token\AccessTokenInterface;
use Kitt3n\AzureAdForSymfonyBundle\Service\MicrosoftGraphService;

class SingleSignOnController extends GenericSignOnController
{
    protected $cookieName = 'ssofs_aafs';

    protected $sessionName = 'ssofs_aafs';

    protected $prefix = 'ssofs_aafs_';

    protected $tokenProvider = 'aafs';

    protected $routeToConnectAction = 'azure_ad_for_symfony_connect';

    protected $routeToRefreshTokenAction = 'azure_ad_for_symfony_refresh_token';

    protected $errorTemplate = '@AzureAdForSymfonyBundle/single-sign-on/error.html.twig';

    protected $successTemplate = '@AzureAdForSymfonyBundle/single-sign-on/success.html.twig';

    protected $graphMeSelect = '$select=businessPhones,displayName,givenName,jobTitle,mail,mobilePhone,officeLocation,preferredLanguage,surname,userPrincipalName,id,employeeId';

    protected $specificOauthService;

    protected $specificConfigService;

    protected $specificIdentityService;

    protected $microsoftGraphService;

    /** @var GenericProvider $oauthClient */
    protected $oauthClient;

    protected $config;

    public function __construct(
        RequestStack $requestStack,
        GenericOauthService $oauthService,
        GenericConfigService $configService,
        GenericCookieService $cookieService,
        SpecificOauthService $specificOauthService, 
        SpecificConfigService $specificConfigService,
        SpecificIdentityService $specificIdentityService,
        MicrosoftGraphService $microsoftGraphService
    ) {
        parent::__construct($requestStack, $oauthService, $configService, $cookieService);
        
        $this->specificOauthService = $specificOauthService;
       
        $this->specificConfigService = $specificConfigService;
        $this->config = $this->specificConfigService->getConfig();

        $this->oauthService = $oauthService;
        $this->oauthClient = $oauthService->getOauthClient(
            $this->config['oauth']['client_id'],
            $this->config['oauth']['client_secret'],
            $this->config['oauth']['tenant'],
            $this->config['oauth']['redirect_uri'],
            $this->config['oauth']['url_authorize'],
            $this->config['oauth']['url_access_token'],
            $this->config['oauth']['url_resource_owner_details'],
            $this->config['oauth']['scopes']
        );

        $this->specificIdentityService = $specificIdentityService;

        $this->microsoftGraphService = $microsoftGraphService;
    }

    /**
     * @Route("/{_locale}/sso/azure/ad/connect", name="azure_ad_for_symfony_connect"),
     *          defaults={
     *         "_locale": "en"
     *     }
     */
    public function connectAction(Request $request): Response
    {
        
        return parent::connectAction($request);

    }   

    /**
     * @Route("/{_locale}/sso/azure/ad/refresh-token", name="azure_ad_for_symfony_refresh_token"),
     *          defaults={
     *         "_locale": "en"
     *     }
     */
    public function refreshTokenAction(Request $request): Response
    {
        $return = parent::refreshTokenAction($request);

        $session = $request->getSession();

        $accessToken = $session->get('SingleSignOnController::processAction::accessToken');

        if (null === $accessToken) {
            return $this->redirectToRoute($this->routeToConnectAction);
        }

        try {

            $graph = $this->microsoftGraphService->getGraph($accessToken);
            $user = $this->microsoftGraphService->getMicrosoftGraphModelUser($accessToken);

        } catch (Exception\GraphException $e) {

            if($session->get('SingleSignOnController::processAction::redirect') === 1) {
                $parameters['error'] = $e->getMessage() . '.';
                $parameters['suggestion'] = 'Please try again.';
                $session->set('SingleSignOnController::processAction::redirect', null);
                return $this->render($this->errorTemplate, $parameters);
            }

            $session->set('SingleSignOnController::processAction::redirect', 1);
            return $this->redirectToRoute($this->routeToConnectAction);

        } catch (\Exception $e) {
            $parameters['exception'] = $e;
            $parameters['error'] = $e->getMessage();
            $parameters['suggestion'] = 'Please try again.';
            $session->set('SingleSignOnController::processAction::redirect', null);
            return $this->render($this->errorTemplate, $parameters);
        }

        $identity = $this->specificIdentityService->createIdentity($accessToken, $graph, $user);

        $this->specificIdentityService->persistIdentity($identity);

        if(isset($this->config['oauth']['redirect_route']['success'])) {
            return $this->redirectToRoute($this->config['oauth']['redirect_route']['success']);
        }

        return $return;

    }

    /**
     * @Route("/{_locale}/sso/azure/ad/process", name="azure_ad_for_symfony_process"),
     *          defaults={
     *         "_locale": "en"
     *     }
     */
    public function processAction(Request $request): Response
    {
        /**
         * Get error from query parameters
         */
        $oauthErrorFromQuery = $request->query->get('error');

        if(isset($oauthErrorFromQuery)) { 
            $oauthErrorUriFromQuery = $request->query->get('error_uri');
            if(isset($oauthErrorUriFromQuery)) { 
                return $this->redirect(
                    $oauthErrorUriFromQuery,
                    302
                );
            }
        }
        
        $session = $request->getSession();
       
        $return = parent::processAction($request);

        $accessToken = $session->get('SingleSignOnController::processAction::accessToken');

        try {

            $graph = $this->microsoftGraphService->getGraph($accessToken);
            $user = $this->microsoftGraphService->getMicrosoftGraphModelUser($accessToken);

        } catch (Exception\GraphException $e) {

            if($session->get('SingleSignOnController::processAction::redirect') === 1) {
                $parameters['error'] = $e->getMessage() . '.';
                $parameters['suggestion'] = 'Please try again.';
                $session->set('SingleSignOnController::processAction::redirect', null);
                return $this->render($this->errorTemplate, $parameters);
            }

            $session->set('SingleSignOnController::processAction::redirect', 1);
            return $this->redirectToRoute($this->routeToConnectAction);

        } catch (\Throwable $e) {
            $parameters['exception'] = $e;
            $parameters['error'] = $e->getMessage();
            $parameters['suggestion'] = 'Please try again.';
            $session->set('SingleSignOnController::processAction::redirect', null);
            return $this->render($this->errorTemplate, $parameters);
        } catch (\Exception $e) {
            $parameters['exception'] = $e;
            $parameters['error'] = $e->getMessage();
            $parameters['suggestion'] = 'Please try again.';
            $session->set('SingleSignOnController::processAction::redirect', null);
            return $this->render($this->errorTemplate, $parameters);
        }

        $identity = $this->specificIdentityService->createIdentity($accessToken, $graph, $user);

        $this->specificIdentityService->persistIdentity($identity);

        if(isset($this->config['oauth']['redirect_route']['success'])) {
            return $this->redirectToRoute($this->config['oauth']['redirect_route']['success']);
        }

        return $return;

    }

	/**
	 * 
	 * @return string
	 */
	function getCookieNameSuffix(): string {
		return $this->cookieNameSuffix;
	}

    protected function getUserGroupIdsViaGraph(Graph $graph, Model\User $user) : Exception\GraphException|array
    {

        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession();

        $userGroupsFromGraph = $session->get('userGroupsFromGraph');
        if(!isset($userGroupsFromGraph)) {

            try {

                /**
                 * Get groups user is member of
                 */
                $userGroupsFromGraph = $graph->createRequest('GET', "/users/" . $user->getId() . "/memberOf")
                ->setReturnType(Model\Group::class)
                ->execute();
                
            } catch (Exception\GraphException $e) {

                throw $e;

            }

            $session->set('userGroupsFromGraph', $userGroupsFromGraph);

        }
        
        $userGroupIds = [];
        foreach($userGroupsFromGraph as $userGroupFromGraph) {
            $userGroupIds[] = $userGroupFromGraph->getId();
        }

        $session->set('userGroupIds', $userGroupIds);

        return $userGroupIds;

    }

    protected function getAppRoleIdsViaGraph(Graph $graph, Model\User $user) : Exception\GraphException|array
    {

        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession();

        $appRolesFromGraph = $session->get('appRolesFromGraph');
        if(!isset($appRolesFromGraph)) {
            
            try {

                /**
                 * Get groups user is member of
                 */
                $appRolesFromGraph = $graph->createRequest('GET', "/users/" . $user->getId() . "/appRoleAssignments")
                ->setReturnType(Model\AppRoleAssignment::class)
                ->execute();
                
            } catch (Exception\GraphException $e) {
    
                throw $e;
    
            }

            $session->set('appRolesFromGraph', $appRolesFromGraph);

        }
        
        $appRoleIds = [];
        foreach($appRolesFromGraph as $appRole) {
            $appRoleIds[] = $appRole->getAppRoleId();
        }   

        $session->set('appRoleIds', $appRoleIds);

        return $appRoleIds;

    }

    protected function userHasAccess(Graph $graph, Model\User $user, string $type = 'backend') : Exception\GraphException|\Exception|bool
    {
        if ($type !== 'backend' and $type !== 'frontend') {
            throw new \Exception('Unsupported type ' . $type . '.');
        } 
        
        $groupsFromParameters = $this->config['oauth']['groups'];

        if ($groupsFromParameters[$type] !== '--') {

            $userGroupIds = $this->getUserGroupIdsViaGraph($graph, $user);

            if (in_array(needle: $groupsFromParameters[$type], haystack: $userGroupIds)) {
                return true;
            }

            return false;

        }

        $appRolesFromParameters = $this->config['oauth']['app_roles'];

        if ($appRolesFromParameters[$type] !== '--') {

            $appRoleIds = $this->getAppRoleIdsViaGraph($graph, $user);

            if (in_array(needle: $appRolesFromParameters[$type], haystack: $appRoleIds)) {
                return true;
            }

            return false;

        }

        throw new \Exception('Misconfiguration for groups/app_roles');

    }

    protected function userIsAdministrator(Graph $graph, Model\User $user, string $type = 'admin') : Exception\GraphException|\Exception|bool
    {
        if ($type !== 'admin') {
            throw new \Exception('Unsupported type ' . $type . '.');
        } 

        $groupsFromParameters = $this->config['oauth']['groups'];

        if ($groupsFromParameters[$type] !== '--') {

            $userGroupIds = $this->getUserGroupIdsViaGraph($graph, $user);

            if (in_array(needle: $groupsFromParameters[$type], haystack: $userGroupIds)) {
                return true;
            }

            return false;

        }

        $appRolesFromParameters = $this->config['oauth']['app_roles'];

        if ($appRolesFromParameters[$type] !== '--') {

            $appRoleIds = $this->getAppRoleIdsViaGraph($graph, $user);

            if (in_array(needle: $appRolesFromParameters[$type], haystack: $appRoleIds)) {
                return true;
            }

            return false;

        }

        throw new \Exception('Misconfiguration for groups');
        
    }

    /**
     * @Route("/{_locale}/sso/azure/ad/revoke-sign-in-sessions", name="azure_ad_for_symfony_revoke_sign_in_sessions"),
     *          defaults={
     *         "_locale": "en"
     *     }
     */
    public function revokeSignInSessionsAction(Request $request): Response
    {
        $session = $request->getSession();
        $accessToken = $session->get('SingleSignOnController::processAction::accessToken');

        try {

            //$graph = $this->microsoftGraphService->getGraph($accessToken);
            $user = $this->microsoftGraphService->revokeSignInSessionsForUser($accessToken);
        

        } catch (Exception\GraphException $e) {

            $parameters['exception'] = $e;
            $parameters['error'] = $e->getMessage();
            return $this->render($this->errorTemplate, $parameters);

        } catch (\Exception $e) {
            $parameters['exception'] = $e;
            $parameters['error'] = $e->getMessage();
            return $this->render($this->errorTemplate, $parameters);
        }

        if(isset($this->config['oauth']['redirect_route']['success'])) {
            return $this->redirectToRoute('restrictions_complete_logout'
                //$this->config['oauth']['redirect_route']['success']
            );
        }

        $parameters['exception'] = 'oauth redirect_route success not set';
        $parameters['error'] = 'oauth redirect_route success not set';
        return $this->render($this->errorTemplate, $parameters);

    }

}