<?php 

namespace Kitt3n\AzureAdForSymfonyBundle\Service;
use League\OAuth2\Client\Token\AccessTokenInterface;
use Microsoft\Graph\Graph;
use Microsoft\Graph\Model;
use Microsoft\Graph\Exception;
use Kitt3n\AzureAdForSymfonyBundle\Entity\Identity;
use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService as SpecificConfigService;
use Symfony\Component\HttpFoundation\RequestStack;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CryptoService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CookieService;

class IdentityService //extends AbstractService
{
    protected $cookieName = 'ssofs_aafs';

    protected $sessionName = 'ssofs_aafs';

    protected $requestStack;

    protected $configService;

    protected $config;

    public function __construct( 
        RequestStack $requestStack,
        SpecificConfigService $configService
    ) {
        $this->requestStack = $requestStack;
        $this->configService = $configService;
        $this->config = $this->configService->getConfig();
    }
    
    public function createIdentity(AccessTokenInterface $accessToken, Graph $graph, Model\User $user)
    { 
        // if ($graph === null) {
        //     return parent::createIdentity($accessToken);
        // }

        // if ($user === null) {
        //     return parent::createIdentity($accessToken);
        // }

        return $identity = new Identity(
            token: $token = $accessToken->getToken(),
            time: time(),
            expires: $expires = $accessToken->getExpires(),
            email: $email = $user->getMail() ?? $user->getUserPrincipalName(),
            username: substr($user->getId(), 0, 50), //$email,
            password: $password = hash('sha512', $token),
            firstname: $firstname = $user->getGivenName() ?? $user->getDisplayName(),
            lastname: $lastname = $user->getSurname() ?? '',
            groupIds: $groupdIds = $this->getUserGroupIdsViaGraph($graph, $user),
            appRoleIds: $appRoleIds = $this->getAppRoleIdsViaGraph($graph, $user),
            backendAccess: $backendAccess = $this->userHasAccess($graph, $user, 'backend'),
            frontendAccess: $frontendAccess = $this->userHasAccess($graph, $user, 'frontend'),
            admin: $admin = $this->userIsAdministrator($graph, $user, 'admin'),
            employeeId: $employeeId = $user->getEmployeeId() ?? '',
            jobTitle: $jobTitle = $user->getJobTitle() ?? '',
            officeLocation: $officeLocation = $user->getOfficeLocation() ?? '',
            mobilePhone: $mobilePhone = $user->getMobilePhone() ?? '',
            preferredLanguage: $preferredLanguage = $user->getPreferredLanguage() ?? '',
            extensionAttribute1: $extensionAttribute1 = (($extensionAttributes = $user->getOnPremisesExtensionAttributes()) === null ? '' : ($extensionAttributes->getExtensionAttribute1() ?? '')),
            extensionAttribute2: $extensionAttribute2 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute2() ?? '')),
            extensionAttribute3: $extensionAttribute3 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute3() ?? '')),
            extensionAttribute4: $extensionAttribute4 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute4() ?? '')),
            extensionAttribute5: $extensionAttribute5 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute5() ?? '')),
            extensionAttribute6: $extensionAttribute6 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute6() ?? '')),
            extensionAttribute7: $extensionAttribute7 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute7() ?? '')),
            extensionAttribute8: $extensionAttribute8 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute8() ?? '')),
            extensionAttribute9: $extensionAttribute9 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute9() ?? '')), 
            extensionAttribute10: $extensionAttribute10 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute10() ?? '')),
            extensionAttribute11: $extensionAttribute11 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute11() ?? '')),
            extensionAttribute12: $extensionAttribute12 = ($extensionAttributes === null ? '' :($extensionAttributes->getExtensionAttribute12() ?? '')),
            extensionAttribute13: $extensionAttribute13 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute13() ?? '')),
            extensionAttribute14: $extensionAttribute14 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute14() ?? '')),
            extensionAttribute15: $extensionAttribute15 = ($extensionAttributes === null ? '' : ($extensionAttributes->getExtensionAttribute15() ?? ''))
        );
    }

    public function persistIdentity(Identity $identity)
    { 
        $serializedIdentity = serialize($identity);

        if($this->config['handlers']['session']) {

            $request = $this->requestStack->getCurrentRequest();
            $session = $request->getSession();

            $encryptedSerializedIdentity = CryptoService::encrypt(
                message: $serializedIdentity,
                key: $this->config['encryption']['secret']
            );

            $session->set($this->sessionName, $encryptedSerializedIdentity);

        }

        if($this->config['handlers']['cookie']) {
            CookieService::saveLargeCookie(
                name: $this->cookieName,
                value: $serializedIdentity,
                expires: $identity->getExpires(),
                path: '/',
                encrypt: true,
                key: $this->config['encryption']['secret'],
            );
        }
    }

	// /**
	//  * 
	//  * @return string
	//  */
	// function getCookieNameSuffix(): string {
	// 	return $this->cookieNameSuffix;
	// }

    public function getUserGroupIdsViaGraph(Graph $graph, Model\User $user) : Exception\GraphException|array
    {

        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession();

        $userGroupsFromGraph = $session->get('userGroupsFromGraph');
        if(!isset($userGroupsFromGraph)) {

            try {

                /**
                 * Get groups user is member of
                 */
                $userGroupsFromGraph = $graph->createRequest('GET', "/users/" . $user->getId() . "/memberOf")
                ->setReturnType(Model\Group::class)
                ->execute();
                
            } catch (Exception\GraphException $e) {

                throw $e;

            }

            $session->set('userGroupsFromGraph', $userGroupsFromGraph);

        }
        
        $userGroupIds = [];
        foreach($userGroupsFromGraph as $userGroupFromGraph) {
            $userGroupIds[] = $userGroupFromGraph->getId();
        }

        $session->set('userGroupIds', $userGroupIds);

        return $userGroupIds;

    }

    public function getAppRoleIdsViaGraph(Graph $graph, Model\User $user) : Exception\GraphException|array
    {

        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession();

        $appRolesFromGraph = $session->get('appRolesFromGraph');
        if(!isset($appRolesFromGraph)) {
            
            try {

                /**
                 * Get groups user is member of
                 */
                $appRolesFromGraph = $graph->createRequest('GET', "/users/" . $user->getId() . "/appRoleAssignments")
                ->setReturnType(Model\AppRoleAssignment::class)
                ->execute();
                
            } catch (Exception\GraphException $e) {
    
                throw $e;
    
            }

            $session->set('appRolesFromGraph', $appRolesFromGraph);

        }
        
        $appRoleIds = [];
        foreach($appRolesFromGraph as $appRole) {
            $appRoleIds[] = $appRole->getAppRoleId();
        }   

        $session->set('appRoleIds', $appRoleIds);

        return $appRoleIds;

    }

    public function userHasAccess(Graph $graph, Model\User $user, string $type = 'backend') : Exception\GraphException|\Exception|bool
    {
        if ($type !== 'backend' and $type !== 'frontend') {
            throw new \Exception('Unsupported type ' . $type . '.');
        } 

        if ($this->userIsAdministrator($graph, $user, 'admin')) {
            return true;
        }
        
        $groupsFromParameters = $this->config['oauth']['groups'];

        if ($groupsFromParameters[$type] !== '--') {

            $userGroupIds = $this->getUserGroupIdsViaGraph($graph, $user);

            if (in_array(needle: $groupsFromParameters[$type], haystack: $userGroupIds)) {
                return true;
            }

            return false;

        }

        $appRolesFromParameters = $this->config['oauth']['app_roles'];

        if ($appRolesFromParameters[$type] !== '--') {

            $appRoleIds = $this->getAppRoleIdsViaGraph($graph, $user);

            if (in_array(needle: $appRolesFromParameters[$type], haystack: $appRoleIds)) {
                return true;
            }

            return false;

        }

        throw new \Exception('Misconfiguration for groups/app_roles');

    }

    public function userIsAdministrator(Graph $graph, Model\User $user, string $type = 'admin') : Exception\GraphException|\Exception|bool
    {
        if ($type !== 'admin') {
            throw new \Exception('Unsupported type ' . $type . '.');
        } 

        $groupsFromParameters = $this->config['oauth']['groups'];

        if ($groupsFromParameters[$type] !== '--') {

            $userGroupIds = $this->getUserGroupIdsViaGraph($graph, $user);

            if (in_array(needle: $groupsFromParameters[$type], haystack: $userGroupIds)) {
                return true;
            }

            return false;

        }

        $appRolesFromParameters = $this->config['oauth']['app_roles'];

        if ($appRolesFromParameters[$type] !== '--') {

            $appRoleIds = $this->getAppRoleIdsViaGraph($graph, $user);

            if (in_array(needle: $appRolesFromParameters[$type], haystack: $appRoleIds)) {
                return true;
            }

            return false;

        }

        throw new \Exception('Misconfiguration for groups');
        
    }
}