<?php 

namespace Kitt3n\AzureAdForSymfonyBundle\Service;

use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\ConfigService as GenericConfigService;

class ConfigService 
{

	protected $genericConfigService;

	protected $genericConfig;

    private  $treeBuilderRootNode = 'azure_ad_for_symfony';
    
    private  $parameters = null;

    public function __construct(
        ParameterBagInterface $parameters,
		GenericConfigService $genericConfigService
    ) {
        $this->parameters = $parameters;
		$this->genericConfigService = $genericConfigService;
		$this->genericConfig = $this->genericConfigService->getConfig();
    }

	/**
	 * 
	 * @return mixed
	 */
	 function getTreeBuilderRootNode() {
		return $this->treeBuilderRootNode;
	}
	
	/**
	 * 
	 * @return mixed
	 */
	 function getConfig() {
		$config = array_replace_recursive(
			$this->genericConfig, 
			$this->getParameters()->get($this->getTreeBuilderRootNode())
		);
		return $config;
	}
	
	/**
	 * 
	 * @return mixed
	 */
	function getParameters() {
		return $this->parameters;
	}
}