<?php 

namespace Kitt3n\AzureAdForSymfonyBundle\Service;

use League\OAuth2\Client\Token\AccessTokenInterface;
use Microsoft\Graph\Graph;
use Microsoft\Graph\Exception;
use Microsoft\Graph\Model;

class MicrosoftGraphService extends AbstractService
{
    protected $graphMeSelect = '$select=businessPhones,displayName,givenName,jobTitle,mail,mobilePhone,officeLocation,preferredLanguage,surname,userPrincipalName,id,employeeId,onPremisesExtensionAttributes';

    protected $graphUsersSelect = '$select=displayName,givenName,surname,jobTitle,mail,businessPhones,mobilePhone,userPrincipalName,id,companyName,department,employeeId,officeLocation,onPremisesExtensionAttributes&$count=true&ConsistencyLevel=eventual&$top=30&$orderby=displayName asc'; //&$top=50&$orderby=displayName asc
    
    protected $graphUsersFilter = '$filter=companyName ge \' \' AND department ge \' \' AND ((businessPhones/any(p:p ge \' \')) OR mobilePhone ge \' \' OR mail ge \' \')'; 

    /**
     * Get User via Graph
     * 
     * @param AccessTokenInterface $accessToken
     * @return Model\User|Exception\GraphException|\Exception|\Throwable
     */
    public function revokeSignInSessionsForUser(AccessTokenInterface $accessToken)
    {    

        try {

            $graph = $this->getGraph($accessToken);

            $user = $this->getMicrosoftGraphModelUser($accessToken);

            $userId = $user->getId(); 
            
            $graph->createRequest('POST', '/users/'. $userId . '/revokeSignInSessions')
                ->execute();

            return $user;

        } catch (Exception\GraphException $e) {
            
            return $e;
        
        } catch (\Exception $e) {
        
            return $e;
        
        }

    }

    /**
     * Get User via Graph
     * 
     * @param AccessTokenInterface $accessToken
     * @return Model\User|Exception\GraphException|\Exception|\Throwable
     */
    public function getMicrosoftGraphModelUser(AccessTokenInterface $accessToken)
    {    

        try {

            $graph = $this->getGraph($accessToken);

            $user = $graph->createRequest('GET', '/me?' . $this->graphMeSelect)
                ->setReturnType(Model\User::class)
                ->execute();

            return $user;

        } catch (Exception\GraphException $e) {
            
            return $e;
        
        } catch (\Exception $e) {
        
            return $e;
        
        }

    }

    /**
     * Get Users via Graph
     * 
     * @param AccessTokenInterface $accessToken
     * 
     */
    public function getMicrosoftGraphModelUsers(
        AccessTokenInterface $accessToken, 
        string $nextLink = '', 
        string $andFilter = '', 
        string $andSearch = ''
        ) {    

        try {

            $graph = $this->getGraph($accessToken);

            $requestUrl = "/users?" . $this->graphUsersSelect . '&' . $this->graphUsersFilter;

            if (!empty($andFilter)) {
                $requestUrl .= str_replace('&', '%26', $andFilter);
            }

            if (!empty($andSearch)) {
                $requestUrl .= "&\$search=" . str_replace('&', '%26', $andSearch);
            }

            if (!empty($nextLink)) {
                $requestUrl = str_replace('https://graph.microsoft.com/v1.0', '', $nextLink);
            }

            $users = $graph->createRequest('GET', $requestUrl)
            //->setReturnType(Model\User::class)
            ->execute();

            return $users->getBody();

        } catch (Exception\GraphException $e) {
            
            return $e;
        
        } catch (\Exception $e) {
        
            return $e;
        
        }

    }

    /**
     * Get Users via Graph
     * 
     * @param AccessTokenInterface $accessToken
     * 
     */
    public function getMicrosoftGraphModelUserCount(AccessTokenInterface $accessToken)
    {    

        try {

            $graph = $this->getGraph($accessToken);

            $response = $graph->createRequest('GET', "/users/\$count?ConsistencyLevel=eventual")
            ->execute();

            $userCount = $response->getBody();

            return (int) $userCount;

        } catch (Exception\GraphException $e) {
            
            return $e;
        
        } catch (\Exception $e) {
        
            return $e;
        
        }

    }

    public function getGraph(AccessTokenInterface $accessToken) 
    {
        $graph = new Graph();
        $graph->setAccessToken($accessToken->getToken());
        return $graph;
    }
}