<?php 

namespace Kitt3n\AzureAdForSymfonyBundle\Service;

use League\OAuth2\Client\Provider\GenericProvider;

use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService;

use Kitt3n\SingleSignOnForSymfonyBundle\Service\ConfigService as GenericConfigService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\OauthService as GenericOauthService;

class OauthService
{
    private $configService = null;

    private $genericConfigService = null;

    private $genericOauthService = null;

    public function __construct(
       ConfigService $configService,
       GenericConfigService $genericConfigService,
       GenericOauthService $genericOauthService
    ) {
        $this->configService = $configService;
        $this->genericConfigService = $genericConfigService;
        $this->genericOauthService = $genericOauthService;
    }
    
    public function getOauthClient(): GenericProvider
    {

        // Initialize the OAuth client
        $oauthClient = $this->genericOauthService->getOauthClient(
            ($azureAdConfig = $this->configService->getConfig())['oauth']['azure_ad']['client_id'],
            $azureAdConfig['oauth']['azure_ad']['client_secret'],
            $azureAdConfig['oauth']['azure_ad']['tenant'],
            $azureAdConfig['oauth']['azure_ad']['redirect_uri'],
            $azureAdConfig['oauth']['azure_ad']['url_authorize'],
            $azureAdConfig['oauth']['azure_ad']['url_access_token'],
            $azureAdConfig['oauth']['azure_ad']['url_resource_owner_details'],
            $azureAdConfig['oauth']['azure_ad']['scopes']
        );

        return $oauthClient;
    }

}