<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Controller;

use KITT3N\Pimcore\RestrictionsBundle\Controller\Interfaces\RestrictionsBundleControllerInterface;
use KITT3N\Pimcore\RestrictionsBundle\Form\LoginFormType;
use Pimcore\Config;
use Pimcore\Controller\FrontendController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Guard\GuardAuthenticatorHandler;
use Pimcore\Model\User;
use Pimcore\Bundle\AdminBundle\Security\User\User as AdminUser;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;

use Symfony\Component\HttpFoundation\Session\Attribute\AttributeBagInterface;
use Pimcore\Tool\Session;

use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService as AzureAdForSymfonyBundleConfigService;
use Kitt3n\AzureAdForSymfonyBundle\Entity\Identity as AzureAdForSymfonyBundleIdentity;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CryptoService as SingleSignOnForSymfonyBundleCryptoService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CookieService as SingleSignOnForSymfonyBundleCookieService;
use Symfony\Component\HttpFoundation\RequestStack;
use Pimcore\Model\User\UserRole;
use Pimcore\Model\User\Role;
use Pimcore\Tool\Admin;

use KITT3N\Pimcore\RestrictionsBundle\Service\ConfigService;
use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;

use Pimcore\Bundle\CoreBundle\EventListener\Frontend\FullPageCacheListener;

class SecureController extends \KITT3N\Pimcore\LayoutsBundle\Controller\DefaultController
{
    private $azureAdForSymfonyBundleConfigService;

    private $azureAdForSymfonyBundleConfig;

    protected $configService;
    protected $config;

    private $requestStack;

    private $guardHandler;

    private $adminAuthenticator;

    private $loginFormAuthenticator;

    private $tokenStorageUserResolver;

    private $securityService;

    protected $fullPageCacheListener;

    public function __construct(
        RequestStack $requestStack,
        AzureAdForSymfonyBundleConfigService $azureAdForSymfonyBundleConfigService,
        ConfigService $configService,

        GuardAuthenticatorHandler $guardHandler, 
        \Pimcore\Bundle\AdminBundle\Security\Guard\AdminAuthenticator $adminAuthenticator,
        \KITT3N\Pimcore\RestrictionsBundle\Security\Guard\LoginFormAuthenticator $loginFormAuthenticator,
        \Pimcore\Bundle\AdminBundle\Security\User\TokenStorageUserResolver $tokenStorageUserResolver,

        SecurityService $securityService,

        FullPageCacheListener $fullPageCacheListener
    ) {
        $this->requestStack = $requestStack;
        $this->azureAdForSymfonyBundleConfigService = $azureAdForSymfonyBundleConfigService;
        $this->azureAdForSymfonyBundleConfig = $this->azureAdForSymfonyBundleConfigService->getConfig();

        $this->configService = $configService;
        $this->config = $this->configService->getConfig();

        $this->guardHandler = $guardHandler;
        $this->adminAuthenticator = $adminAuthenticator;
        $this->loginFormAuthenticator = $loginFormAuthenticator;
        $this->tokenStorageUserResolver = $tokenStorageUserResolver;

        $this->securityService = $securityService;

        $this->fullPageCacheListener = $fullPageCacheListener;

    }

    protected function handleAzureAdLogin() {
        
        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession(); 

        //if ( ! $encryptedIdentity = $session->get('ssofs_aafs')) {

        if ( ! $encryptedIdentity = SingleSignOnForSymfonyBundleCookieService::retrieveLargeCookie('ssofs_aafs', false)) {
            // Not logged in via azure ad

            // // Log out ssofs_aafs users
            // if($this->securityService->getCurrentBackendUser() !== null &&  
            // substr($this->securityService->getCurrentBackendUser()->getName(), 0, 9) === 'ssofs_aafs') {
            //     Session::invalidate();
            // }

            return false;
        }
        //}

        $identity = 
            unserialize(
                $decryptedIdentity = 
                    SingleSignOnForSymfonyBundleCryptoService::decrypt(
                        $encryptedIdentity, 
                        $this->azureAdForSymfonyBundleConfig['encryption']['secret']
            )
        );

        // Check expiration date
        if (time() > $identity->getExpires()) {
            $session->set('ssofs_aafs', null);
            return false;
        }

        // backend
        if ($identity->getBackendAccess()) {

             // create or update backend user
             $pimcoreUserRole = Role::getByName(
                $this->azureAdForSymfonyBundleConfig['oauth']['groups']['backend'], 
                [
                    'limit' => 1,
                ]
            );

            // create or update backend user
            $pimcoreUser = User::getByName(
                $identity->getUsername(), 
                [
                    'limit' => 1,
                    //'active' => true
                ]
            );

            if ( ! $pimcoreUser) {
                // create backend user
                $pimcoreUser = new User();
            }

            $pimcoreUser->setName($identity->getUsername());
            $pimcoreUser->setPassword($identity->getPassword());
            $pimcoreUser->setEmail($identity->getEmail());
            $pimcoreUser->setFirstname($identity->getFirstname());
            $pimcoreUser->setLastname($identity->getLastname());
            $pimcoreUser->setRoles([$pimcoreUserRole->getId()]);
            $pimcoreUser->setActive(true);
            $pimcoreUser->setAdmin(false);
            $pimcoreUser->setParentId($this->config['user']['backend']['parent_id']);
            $pimcoreUser->save();

            $adminUser = new AdminUser($pimcoreUser);

            // allways null because our route is not in the array 
            // ['pimcore_admin_login','pimcore_admin_login_check']
            // in Pimcore\Bundle\AdminBundle\Security\Guard\AdminAuthenticator
            $response = $this->guardHandler->authenticateUserAndHandleSuccess(
                $adminUser,
                $request,
                $this->adminAuthenticator,
                "pimcore_admin"
            );

        }

        // frontend
        if ($identity->getFrontendAccess()) {

            $frontendUserGroup = \Pimcore\Model\DataObject\Group::getByKey(
                $this->azureAdForSymfonyBundleConfig['oauth']['groups']['frontend'],
                [
                    'limit' => 1,
                    'unpublished' => false
                ]
            );
            
            // create or update frontend user
            $frontendUser = \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User::getByUsername(
                $identity->getUsername(),
                [
                    'limit' => 1,
                    'unpublished' => true
                ]
            );

            if ( ! $frontendUser) {
                // create backend user
                $frontendUser = new \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User();
            }

            $frontendUser->setKey($identity->getUsername());
            $frontendUser->setUsername($identity->getUsername());
            $frontendUser->setPassword($identity->getPassword());
            $frontendUser->setEmail($identity->getEmail());
            $frontendUser->setFirstname($identity->getFirstname());
            $frontendUser->setLastname($identity->getLastname());
            $frontendUser->setGroup($frontendUserGroup);

            $availableGroups = new \Pimcore\Model\DataObject\Group\Listing();
            $availableGroups->setCondition("o_key IN (?)", [$identityGroupIds = $identity->getGroupIds()]);
            $setGroups = [];
            foreach ($availableGroups as $availableGroup) {
               if (in_array($availableGroup->getKey(), $identityGroupIds)) {
                $setGroups[] = $availableGroup;
               }
            }
            $frontendUser->setGroups($setGroups);

            $frontendUser->setRoles(['ROLE_USER']);
            $frontendUser->setPublished(true);
            $frontendUser->setParentId($this->config['user']['frontend']['parent_id']);
            $frontendUser->save();

            $frontenduserResponse = $this->guardHandler->authenticateUserAndHandleSuccess(
                $frontendUser,
                $request,
                $this->loginFormAuthenticator,
                "restrictions"
            );
        }

        if ($identity->getBackendAccess()) {

            Session::useSession(function (AttributeBagInterface $adminSession) use ($pimcoreUser) {
                Session::regenerateId();
                $adminSession->set('user', $pimcoreUser);
            });

        }

        return true;
    }

     /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/sso/azure/ad/login",
     *     name="restrictions_azure_ad_login",
     *          defaults={
     *         "_locale": "de"
     *     }
     * )
     */
    public function azureAdLoginAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/azure-ad-login.html.twig'
    ) {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        if ( ! $this->azureAdForSymfonyBundleConfig['active']) {
            return $this->redirectToRoute('restrictions_login');
        }

        if ( ! $this->handleAzureAdLogin()) { 
            return $this->redirectToRoute('restrictions_login');
        }

        $parameters = [];

        $parameters["__user"] = [];
        $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
        $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

        //return $this->renderTemplate($view, $parameters);
        return $this->redirectToRoute('restrictions_login', []);

    }

    /**
     * @param Request $request
     * @param AuthenticationUtils $authenticationUtils
     * @param string $view
     * @Route(
     *     "/{_locale}/login",
     *     name="restrictions_login",
     *          defaults={
     *         "_locale": "de"
     *     }
     * )
     */
    public function loginAction(
        Request $request,
        AuthenticationUtils $authenticationUtils,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/login.html.twig'
    ): Response {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        $parameters = [];

        $parameters["__user"] = [];
        $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
        $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

        $parameters['__login'] = [
            'links' => [],
        ];
        if ( $this->azureAdForSymfonyBundleConfig['active']) {
            $parameters['__login']['links'][] = [
                'href' => $this->generateUrl('azure_ad_for_symfony_connect'),
                'text' => 'Login with Azure AD'
            ];

        }

        $aReturn = parent::getBamParams($request);

        $aReturn["aOverrides"] = [
            "sTitle" => "Login",
        ];

        $parameters['oDocument'] = $aReturn["oDocument"];
        $parameters['aDocumentProperties'] = $aReturn["aDocumentProperties"];
        $parameters['oUser'] = $aReturn["oUser"];
        $parameters['oWebsiteConfig'] = $aReturn["oWebsiteConfig"];
        $parameters['bIsAllowed'] = $aReturn["bIsAllowed"];

        $parameters['aBamParams'] = $aReturn;

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();
        $parameters['error'] = $error;

        return $this->renderTemplate($view, $parameters);

    }

    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/complete-logout",
     *     name="restrictions_complete_logout",
     *     defaults={
     *         "_locale": "de"
     *     }
     * )
     */
    public function completeLogoutAction(
        Request $request
    ): Response {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        Session::invalidate();

        return $this->redirectToRoute('restrictions_logout', []);

    }


    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/logout",
     *     name="restrictions_logout",
     *     defaults={
     *         "_locale": "de"
     *     }
     * )
     */
    public function logoutAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/logout.html.twig'
    ): Response {
        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");
        return $this->renderTemplate($view, $parameters);
    }

    /**
     * @Route("/programmaticlogin", name="programmaticlogin")
     */
    public function programmaticlogin(
        Request $request, 
        GuardAuthenticatorHandler $guardHandler, 
        \Pimcore\Bundle\AdminBundle\Security\Guard\AdminAuthenticator $adminAuthenticator,
        \KITT3N\Pimcore\RestrictionsBundle\Security\Guard\LoginFormAuthenticator $loginFormAuthenticator,
        \Pimcore\Bundle\AdminBundle\Security\User\TokenStorageUserResolver $tokenStorageUserResolver)
    {

        // if($this->getUser()){
        //     return $this->redirectToRoute('cockpit');
        // }

        // $api = new UserApiClient();
        // $result = $api->getUser($request->query->get('token'));

        // if(!$request->query->get('token') or (isset($result['code']) and $result['code'] == 401)){
        //     throw new \Exception('Login failed');
        // }

        // $this->get('session')->set('api_token', $request->query->get('token'));
        // $user = $this->getDoctrine()->getRepository('App\Entity\Users\User')->find($result['id']);

        $pimcoreUser = User::getByid(2, ['limit' => 1,'unpublished' => true]);
        $adminUser = new AdminUser($pimcoreUser);

        $frontendUser = \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User::getByUsername('marketing', ['limit' => 1]);

        // $token = new UsernamePasswordToken($adminUser, $pimcoreUser->getPassword(), "pimcore_admin", $pimcoreUser->getRoles());
        // $this->get("security.token_storage")->setToken($token);

        // $event = new InteractiveLoginEvent($request, $token);
        // \Pimcore::getContainer()
        //         ->get('event_dispatcher')->dispatch(
        //             $event,
        //             "security.interactive_login"
        //         );

        // return $this->redirectToRoute('pimcore_admin_index');

        // $testuser = 

        $response = $guardHandler->authenticateUserAndHandleSuccess(
            $adminUser,
            $request,
            $adminAuthenticator,
            "pimcore_admin"
        );

        $frontenduserResponse = $guardHandler->authenticateUserAndHandleSuccess(
            $frontendUser,
            $request,
            $loginFormAuthenticator,
            "restrictions"
        );

        if ($response !== null) {
           // return $this->redirectToRoute('pimcore_admin_index');

           Session::useSession(function (AttributeBagInterface $adminSession) use ($pimcoreUser) {
                Session::regenerateId();
                $adminSession->set('user', $pimcoreUser);
            });

            return $response;
        }

        // return $return;

    }
}
