<?php 

namespace KITT3N\Pimcore\RestrictionsBundle\Service;

use Symfony\Component\Security\Core\Security;
use Symfony\Component\HttpFoundation\RequestStack;
use Pimcore\Tool\Admin;
use Pimcore\Tool\Session;

class SecurityService 
{

    protected $sLoginRoute = 'restrictions_login';

    /**
     * @var Security
     */
    private $security;

    private $requestStack;

    private $configService;

    private $config;

    public function __construct(
        Security $security, 
        ConfigService $configService,
        RequestStack $requestStack
    ) {
        $this->security = $security;
        $this->configService = $configService;
        $this->config = $this->configService->getConfig();
        $this->requestStack = $requestStack;
    }

    /**
     * Return frontend user or null
     * 
     * @return \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User|null
     */
    public function getCurrentUser()
    {
        $user = $this->security->getUser();

        return ($user instanceof \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User) ? $user : null;
    }

    /**
     * Return backend user or null
     * 
     * @return \Pimcore\Model\User|null
     */
    public function getCurrentBackendUser()
    {
        $user = (
            ($currentBackendUser = Admin::getCurrentUser()) !== null ?
                $currentBackendUser : Session::getReadonly()->get("user")
        );

        return ($user instanceof \Pimcore\Model\User) ? $user : null;
    }

    
    public function isUserAllowedToAccessDocument($document)
    {

        /* @var array $documentProperties */
        $documentProperties = (($properties = $document->getProperties()) === null ? [] : $properties);

        $currentUser = $this->getCurrentUser();

        $request = $this->requestStack->getCurrentRequest();
        if (!\Pimcore\Tool::isFrontend() || \Pimcore\Tool::isFrontendRequestByAdmin($request)) {
            return true;
        }
        // if ($currentUser instanceof \Pimcore\Bundle\AdminBundle\Security\User\User) {
        //     // Backend User
        //     return true;
        // }

        if ($this->config['documents']['view'] === 'allow') {

            if ($currentUser === null) {
                return true;
            }

            $currenUserGroups = $currentUser->getGroups();
            $currentUserGroupIds = [];
            foreach ($currenUserGroups as $group) {
                $currentUserGroupIds[] = $group->getId();
            }

            $deniedForGroupIds = [];
            foreach($documentProperties as $documentProperty) {
                if ($documentProperty->getType() === 'object' && substr($documentProperty->getName(), 0, strlen('deny')) === 'deny') {
                    if (($group = $documentProperty->getData()) instanceof \Pimcore\Model\DataObject\Group) {
                        $deniedForGroupIds[] = $group->getId();
                    }
                }
            }

            if (count(array_intersect($currentUserGroupIds, $deniedForGroupIds)) > 0) {
                return false;
            }

            return true;

        }

        if ($this->config['documents']['view'] === 'deny') {

            if ($currentUser === null) {
                return false;
            }

            $currenUserGroups = $currentUser->getGroups();
            $currentUserGroupIds = [];
            foreach ($currenUserGroups as $group) {
                $currentUserGroupIds[] = $group->getId();
            }

            $allowedForGroupIds = [];
            foreach($documentProperties as $documentProperty) {
                if ($documentProperty->getType() === 'object' && substr($documentProperty->getName(), 0, strlen('allow')) === 'allow') {
                    if (($group = $documentProperty->getData()) instanceof \Pimcore\Model\DataObject\Group) {
                        $allowedForGroupIds[] = $group->getId();
                    }
                }
            }

            if (count(array_intersect($currentUserGroupIds, $allowedForGroupIds)) === 0) {
                return false;
            }

            return true;
        }

        return true;
    }

}