<?php

namespace KITT3N\Pimcore\RestrictionsBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('kitt3n_pimcore_restrictions');
        $rootNode = $treeBuilder->getRootNode();

        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.

        $rootNode
            ->children()

                ->arrayNode('documents')
                    ->children()
                        ->enumNode('view')
                            ->values(['deny', 'allow'])
                            ->defaultValue('allow')
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('assets')
                    ->children()
                        ->enumNode('view')
                            ->values(['deny', 'allow'])
                            ->defaultValue('allow')
                        ->end()
                        ->enumNode('download')
                            ->values(['deny', 'allow'])
                            ->defaultValue('allow')
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('user')
                    ->children()
                        ->arrayNode('frontend')
                            ->children()
                                ->integerNode('parent_id')->min(1)->defaultValue(1)->end()
                            ->end()
                        ->end()
                        ->arrayNode('backend')
                            ->children()
                                ->integerNode('parent_id')->min(0)->defaultValue(0)->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()

            ->end()
            ;

        return $treeBuilder;
    }
}
