<?php 

namespace KITT3N\Pimcore\RestrictionsBundle\EventListener;
use Symfony\Component\HttpKernel\Event\ResponseEvent;

use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;
use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService as AzureAdForSymfonyBundleConfigService;
use Kitt3n\AzureAdForSymfonyBundle\Service\IdentityService as AzureAdForSymfonyBundleIdentityService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\ConfigService as SingleSignOnForSymfonyBundleConfigService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\OauthService as SingleSignOnForSymfonyBundleOauthService;
use League\OAuth2\Client\Token\AccessTokenInterface;
use Microsoft\Graph\Graph;
use Microsoft\Graph\Model;
use Microsoft\Graph\Exception;

class ResponseListener 
{

    protected $singleSignOnForSymfonyBundleConfigService;

    protected $singleSignOnForSymfonyBundleConfig;

    protected $azureAdForSymfonyBundleConfigService;

    protected $azureAdForSymfonyBundleConfig;

    protected $azureAdForSymfonyBundleIdentityService;
    
    protected $singleSignOnForSymfonyBundleOauthService;

    protected $securityService;

    protected $singleSignOnForSymfonyBundleOauthClient;

    protected $azureAdForSymfonyBundleOauthClient;

    public function __construct(
        SingleSignOnForSymfonyBundleConfigService $singleSignOnForSymfonyBundleConfigService,
        AzureAdForSymfonyBundleConfigService $azureAdForSymfonyBundleConfigService,
        AzureAdForSymfonyBundleIdentityService $azureAdForSymfonyBundleIdentityService,
        SingleSignOnForSymfonyBundleOauthService $singleSignOnForSymfonyBundleOauthService,
        SecurityService $securityService
    ) {

        $this->singleSignOnForSymfonyBundleConfigService = $singleSignOnForSymfonyBundleConfigService;
        $this->singleSignOnForSymfonyBundleConfig = $this->singleSignOnForSymfonyBundleConfigService->getConfig();
       
        $this->azureAdForSymfonyBundleConfigService = $azureAdForSymfonyBundleConfigService;
        $this->azureAdForSymfonyBundleConfig = $this->azureAdForSymfonyBundleConfigService->getConfig();

        $this->azureAdForSymfonyBundleIdentityService = $azureAdForSymfonyBundleIdentityService;

        $this->singleSignOnForSymfonyBundleOauthService = $singleSignOnForSymfonyBundleOauthService;

        $this->singleSignOnForSymfonyBundleOauthClient = $singleSignOnForSymfonyBundleOauthService->getOauthClient(
            $this->singleSignOnForSymfonyBundleConfig['oauth']['client_id'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['client_secret'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['tenant'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['redirect_uri'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['url_authorize'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['url_access_token'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['url_resource_owner_details'],
            $this->singleSignOnForSymfonyBundleConfig['oauth']['scopes']
        );

        $this->azureAdForSymfonyBundleOauthClient = $singleSignOnForSymfonyBundleOauthService->getOauthClient(
            $this->azureAdForSymfonyBundleConfig['oauth']['client_id'],
            $this->azureAdForSymfonyBundleConfig['oauth']['client_secret'],
            $this->azureAdForSymfonyBundleConfig['oauth']['tenant'],
            $this->azureAdForSymfonyBundleConfig['oauth']['redirect_uri'],
            $this->azureAdForSymfonyBundleConfig['oauth']['url_authorize'],
            $this->azureAdForSymfonyBundleConfig['oauth']['url_access_token'],
            $this->azureAdForSymfonyBundleConfig['oauth']['url_resource_owner_details'],
            $this->azureAdForSymfonyBundleConfig['oauth']['scopes']
        );

        $this->securityService = $securityService;

    }

    public function onKernelResponse(ResponseEvent $event)
    {
        $request = $event->getRequest();
        $session = $request->getSession();

        $routeName = $request->attributes->get('_route');

        if (!\Pimcore\Tool::isFrontend() || \Pimcore\Tool::isFrontendRequestByAdmin($request)) {
            return;
        }

        if (substr($routeName, 0, 8) !== 'document') {
            return;
        }

        $currentAccessToken = $session->get('SingleSignOnController::processAction::accessToken');

        if (!$currentAccessToken instanceof AccessTokenInterface) {
            return;
        }
        
        if (!$currentAccessToken->hasExpired()) {
            return;
        }

        if ($this->azureAdForSymfonyBundleConfig['active']) {
            if (($tokenProvider = $session->get('SingleSignOnController::processAction::accessTokenProvider')) === 'aafs') { 
                
                try {

                    $accessToken = $this->azureAdForSymfonyBundleOauthClient->getAccessToken(
                        'refresh_token', 
                        [
                            'refresh_token' => $currentAccessToken->getRefreshToken(),
                        ]
                    );
            
                    $session->set('SingleSignOnController::processAction::accessToken', $accessToken);
        
                } catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException $e) {
                    return;
                }

                try {

                    $graph = new Graph();
                    $graph->setAccessToken($accessToken->getToken());
        
                    $user = $graph->createRequest('GET', '/me')
                        ->setReturnType(Model\User::class)
                        ->execute();
        
                } catch (Exception\GraphException $e) {
                    return;
                }
        
                // Create identity from token
                $identity = $this->azureAdForSymfonyBundleIdentityService->createIdentity($accessToken, $graph, $user);
        
                // TODO Persist identity in cookie/session
                $this->azureAdForSymfonyBundleIdentityService->persistIdentity($identity);
        
                // backend
                if ($identity->getBackendAccess()) {
                    $pimcoreUser = $this->securityService->createOrUpdatePimcoreModelUser($identity);
                }
        
                // frontend
                if ($identity->getFrontendAccess()) {
                    $frontendUser = $this->securityService->createOrUpdateRestrictionsBundleModelDataObjectUser($identity, $this->azureAdForSymfonyBundleConfig['oauth']['groups']['frontend']);
                }

                return;

            }
        }

        try {

            $accessToken = $this->singleSignOnForSymfonyBundleOauthClient->getAccessToken(
                'refresh_token', 
                [
                    'refresh_token' => $currentAccessToken->getRefreshToken(),
                ]
            );
    
            $session->set('SingleSignOnController::processAction::accessToken', $accessToken);

        } catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException $e) {
            return;
        }

        return;

        //$response = $event->getResponse();

        // ... modify the response object
    }
}