<?php 

namespace KITT3N\Pimcore\RestrictionsBundle\Service;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use KITT3N\Pimcore\RestrictionsBundle\Security\UnsafeCrypto;

class CookieService 
{

    private $parameters = null;

    public function __construct(
        ParameterBagInterface $parameters
    ) {
        $this->parameters = $parameters;
    }

    public function getLargeCookie($name, $encrypted = true) 
    { 
        
        if (!isset($_COOKIE[$name])) {
            return false;
        }

        $values = [];
        $count = (int) $_COOKIE[$name];
        for ( $index = 0 ; $index < $count; $index++ ) {
            
            if (!isset($_COOKIE[$name . '_' . $index])) {
                
                return false;

            }

            $values[] = $_COOKIE[$name . '_' . $index];

        }

        $value = implode('', $values);

        if (!$encrypted) {
            return $value;
        }       

        $decrypted_value = UnsafeCrypto::decrypt(
            message: $value,
            key: $this->parameters->get('kitt3n_pimcore_restrictions')['azure']['ad']['encryption']['secret'], 
            encoded: true
        );

        return $decrypted_value;

    }

    // if($encrypt) {
    //     $value = UnsafeCrypto::encrypt(
    //         message: $value,
    //         key: $this->parameters->get('kitt3n_pimcore_restrictions')['azure']['ad']['encryption']['secret'], 
    //         encode: true
    //     );
    // }

    // $split = str_split( $value , 500 );
    // $count = count( $split );

    // $return = [];

    // for ( $index = 0 ; $index < $count; $index++ ) {
    //     $return[] = setcookie( $name . '_' . $index, $split[$index] , $expires , $path );
    // }
    // $return[] = setcookie( $name, $count , $expires , $path );

}