<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Twig\Extension;

use Pimcore\Config;
use Pimcore\Localization\LocaleServiceInterface;
use Pimcore\Model\AbstractModel;
use Pimcore\Model\Document;
use Pimcore\Navigation\Builder;
use Pimcore\Navigation\Container;
use Pimcore\Twig\Extension\Templating\Navigation;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;

class NavigationExtension extends AbstractExtension
{
    /**
     * @var Navigation
     */
    protected $navigationHelper;

    /**
     * @var Builder
     */
    private $builder;

    /**
     * @var LocaleServiceInterface
     */
    protected $localeService;

    /**
     * @var TokenStorageInterface
     */
    protected $tokenStorage;

    /**
     * @param Navigation                  $navigationHelper
     * @param TokenStorageInterface       $tokenStorage
     */

    protected $securityService;
    public function __construct(
        Navigation $navigationHelper,
        TokenStorageInterface $tokenStorage,
        Builder $builder,
        LocaleServiceInterface $localeService,
        SecurityService $securityService
    ) {
        $this->navigationHelper = $navigationHelper;
        $this->tokenStorage = $tokenStorage;
        $this->builder = $builder;
        $this->localeService = $localeService;
        $this->securityService = $securityService;
    }

    /**
     * @return array
     */
    public function getFunctions(): array
    {
        return [
            new TwigFunction('restrictions_build_nav', [$this, 'build']),
        ];
    }

    /**
     * Builds a navigation container by passing params
     * Possible config params are: 'root', 'htmlMenuPrefix', 'pageCallback', 'cache', 'maxDepth', 'active'
     *
     * @param array $params
     *
     * @return Container
     *
     * @throws \Exception
     */
    public function build(array $params): Container
    {
        $optionsResolver = new OptionsResolver();
        $optionsResolver->setDefaults([
            'root' => null,
            'htmlMenuPrefix' => null,
            'pageCallback' => null,
            'cache' => true,
            'cacheLifetime' => null,
            'maxDepth' => null,
            'active' => null,
        ]);

        $options = $optionsResolver->resolve($params);

        return $this->builder->getNavigation(
            $options['active'],
            $options['root'],
            $options['htmlMenuPrefix'],
            function (\Pimcore\Navigation\Page\Document $document, \Pimcore\Model\Document $page) {
                
                $isUserAllowedToAccessDocument = $this->securityService->isUserAllowedToAccessDocument($page);

                if ( ! $isUserAllowedToAccessDocument) {
                    $document->setActive(false);
                    $document->setVisible(false);
                }

                return $page;
                
            },
            $options['cache'],
            $options['maxDepth'],
            $options['cacheLifetime']
        );
    }

}
