<?php

namespace KITT3N\Pimcore\RestrictionsBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('kitt3n_pimcore_restrictions');
        $rootNode = $treeBuilder->getRootNode();

        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.

        $rootNode
            ->children()

                ->arrayNode('documents')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->enumNode('view')
                            ->values(['deny', 'allow'])
                            ->defaultValue('%env(resolve:KPR_DOCUMENTS_VIEW)%')
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('objects')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->enumNode('view')
                            ->values(['deny', 'allow'])
                            ->defaultValue('%env(resolve:KPR_OBJECTS_VIEW)%')
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('assets')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->enumNode('view')
                            ->values(['deny', 'allow'])
                            ->defaultValue('%env(resolve:KPR_ASSETS_VIEW)%')
                        ->end()
                        ->enumNode('download')
                            ->values(['deny', 'allow'])
                            ->defaultValue('%env(resolve:KPR_ASSETS_DOWNLOAD)%')
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('user')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('frontend')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->integerNode('parent_id')->min(1)->defaultValue('%env(resolve:KPR_USER_FRONTEND_PARENT_ID)%')->end()
                            ->end()
                        ->end()
                        ->arrayNode('backend')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->integerNode('parent_id')->min(0)->defaultValue('%env(resolve:KPR_ASSETS_DOWNLOAD)%')->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()

                ->arrayNode('groups')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('mapping')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->arrayNode('backend')
                                    ->arrayPrototype()
                                        ->scalarPrototype()->end()  
                                    ->end()
                                ->end()
                                ->arrayNode('frontend')
                                    ->arrayPrototype()
                                        ->scalarPrototype()->end()  
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()

            ->end()
            ;

        return $treeBuilder;
    }
}
