<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Twig\Extension;

use Pimcore\Config;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;

class UserCanDownloadAssetExtension extends AbstractExtension
{

    private $securityService;

    public function __construct(
        SecurityService $securityService,
    ) {
        $this->securityService = $securityService;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('userCanDownloadAsset', [$this, 'userCanDownloadAsset']),
        ];
    }

    public function userCanDownloadAsset($asset)
    {
        return $this->securityService->isUserAllowedToDownloadAsset($asset);
    }

}
