const plugin = require('tailwindcss/plugin');

colors = {
  primary: 'var(--primary)',
  secondary: 'var(--secondary)',
  tertiary: 'var(--tertiary)',
  'background-footer': 'var(--background-footer)',
};

module.exports = {
  important: true,
  corePlugins: {
    textOpacity: false,
    backgroundOpacity: false,
    borderOpacity: false,
  },
  content: [
    './../../../views/tailwind.html.twig',
    './../../../views/**/*.html.twig',
  ],
  safelist: [
    'text-xs', 'text-sm', 'text-base', 'text-lg', 'text-xl', 'text-2xl', 'text-3xl', 'text-4xl', 'text-5xl', 'text-6xl', 'text-7xl', 'text-8xl', 'text-9xl', 'text-highlight', 'text-highlight-1',
  ],
  theme: {
    screens: {
      sm: '576px',
      md: '768px',
      lg: '992px',
      xl: '1200px',
    },
    extend: {
      spacing: {
        '21/9': 'calc(100% / 21 * 9)',
        '21/7': 'calc(100% / 21 / 7)',
        '21/5': 'calc(100% / 21 * 5)',
        '16/9': 'calc(100% / 16 * 9)',
        '3/2': 'calc(100% / 3 * 2)',
        '4/3': 'calc(100% / 4 * 3)',
        '3/4': 'calc(100% / 3 * 4)',
        '2/3': 'calc(100% / 2 * 3)',
        '1/1': 'calc(100% / 1 * 1)',
        '1/12': '8.333333%',
        '2/12': '16.666667%',
        '3/12': '25%',
        '4/12': '33.333333%',
        '5/12': '41.666667%',
        '6/12': '50%',
        '7/12': '58.333333%',
        '8/12': '66.666667%',
        '9/12': '75%',
        '10/12': '83.333333%',
        '11/12': '91.666667%',
        '12/12': '100%',
      },
      backgroundPosition: {
        'left-center': 'left center',
      },
      transformOrigin: {
        'bottom-center': 'bottom center',
      },
      fontSize: {
        0: 0,
        xs: ['var(--font-size-xs)', { lineHeight: 'var(--line-height-xs)' }],
        sm: ['var(--font-size-sm)', { lineHeight: 'var(--line-height-sm)' }],
        base: ['var(--font-size-base)', { lineHeight: 'var(--line-height-base)' }],
        lg: ['var(--font-size-lg)', { lineHeight: 'var(--line-height-lg)' }],
        xl: ['var(--font-size-xl)', { lineHeight: 'var(--line-height-xl)' }],
        '2xl': ['var(--font-size-2xl)', { lineHeight: 'var(--line-height-2xl)' }],
        '3xl': ['var(--font-size-3xl)', { lineHeight: 'var(--line-height-3xl)' }],
        '4xl': ['var(--font-size-4xl)', { lineHeight: 'var(--line-height-4xl)' }],
        '5xl': ['var(--font-size-5xl)', { lineHeight: 'var(--line-height-5xl)' }],
        '6xl': ['var(--font-size-6xl)', { lineHeight: 'var(--line-height-6xl)' }],
        '7xl': ['var(--font-size-7xl)', { lineHeight: 'var(--line-height-7xl)' }],
        '8xl': ['var(--font-size-8xl)', { lineHeight: 'var(--line-height-8xl)' }],
        '9xl': ['var(--font-size-9xl)', { lineHeight: 'var(--line-height-9xl)' }],
      },
      fontWeight: { 
        '100': '100',
        '200': '200',
        '300': '300',
        '400': '400',
        '500': '500',
        '600': '600',
        '700': '700',
        '800': '800',
        '900': '900',
      },
      colors: {
        'background-footer': 'var(--background-footer)',
        'background-main': 'var(--background-main)',
        'foreground-footer': 'var(--foreground-footer)',
        'foreground-main': 'var(--foreground-main)',
        'highlight': 'var(--highlight)',
        'highlight-1': 'var(--highlight-1)',

        'background-button-login-frontend': 'var(--background-button-login-frontend)',
        'foreground-button-login-frontend': 'var(--foreground-button-login-frontend)',
        'background-button-login-backend': 'var(--background-button-login-backend)',
        'foreground-button-login-backend': 'var(--foreground-button-login-backend)',
        'background-button-login-sso': 'var(--background-button-login-sso)',
        'foreground-button-login-sso': 'var(--foreground-button-login-sso)',
        'background-button-logout': 'var(--background-button-logout)',
        'foreground-button-logout': 'var(--foreground-button-logout)',
      },
      fontFamily: {
        'body': ['var(--font-family-body)', 'sans-serif'],
      },
    },
  },
  plugins: [
    require('@tailwindcss/forms'),
  ],
}

