<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Controller;

use KITT3N\Pimcore\RestrictionsBundle\Controller\Interfaces\RestrictionsBundleControllerInterface;
use KITT3N\Pimcore\RestrictionsBundle\Form\LoginFormType;
use Pimcore\Config;
use Pimcore\Controller\FrontendController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Guard\GuardAuthenticatorHandler;
use Pimcore\Model\User;
use Pimcore\Bundle\AdminBundle\Security\User\User as AdminUser;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;

use Symfony\Component\HttpFoundation\Session\Attribute\AttributeBagInterface;
use Pimcore\Tool\Session;

use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService as AzureAdForSymfonyBundleConfigService;
use Kitt3n\AzureAdForSymfonyBundle\Entity\Identity as AzureAdForSymfonyBundleIdentity;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CryptoService as SingleSignOnForSymfonyBundleCryptoService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CookieService as SingleSignOnForSymfonyBundleCookieService;
use Symfony\Component\HttpFoundation\RequestStack;
use Pimcore\Model\User\UserRole;
use Pimcore\Model\User\Role;
use Pimcore\Tool\Admin;

use KITT3N\Pimcore\RestrictionsBundle\Service\ConfigService;
use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;

use Pimcore\Bundle\CoreBundle\EventListener\Frontend\FullPageCacheListener;

class SecureController extends FrontendController //extends \KITT3N\Pimcore\LayoutsBundle\Controller\DefaultController
{
    private $azureAdForSymfonyBundleConfigService;

    private $azureAdForSymfonyBundleConfig;

    protected $configService;
    protected $config;

    private $requestStack;

    private $guardHandler;

    private $adminAuthenticator;

    private $loginFormAuthenticator;

    private $tokenStorageUserResolver;

    private $securityService;

    protected $fullPageCacheListener;

    public function __construct(
        RequestStack $requestStack,
        AzureAdForSymfonyBundleConfigService $azureAdForSymfonyBundleConfigService,
        ConfigService $configService,

        GuardAuthenticatorHandler $guardHandler, 
        \Pimcore\Bundle\AdminBundle\Security\Guard\AdminAuthenticator $adminAuthenticator,
        \KITT3N\Pimcore\RestrictionsBundle\Security\Guard\LoginFormAuthenticator $loginFormAuthenticator,
        \Pimcore\Bundle\AdminBundle\Security\User\TokenStorageUserResolver $tokenStorageUserResolver,

        SecurityService $securityService,

        FullPageCacheListener $fullPageCacheListener
    ) {
        $this->requestStack = $requestStack;
        $this->azureAdForSymfonyBundleConfigService = $azureAdForSymfonyBundleConfigService;
        $this->azureAdForSymfonyBundleConfig = $this->azureAdForSymfonyBundleConfigService->getConfig();

        $this->configService = $configService;
        $this->config = $this->configService->getConfig();

        $this->guardHandler = $guardHandler;
        $this->adminAuthenticator = $adminAuthenticator;
        $this->loginFormAuthenticator = $loginFormAuthenticator;
        $this->tokenStorageUserResolver = $tokenStorageUserResolver;

        $this->securityService = $securityService;

        $this->fullPageCacheListener = $fullPageCacheListener;

    }

    protected function handleAzureAdLogin() {
        
        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession(); 

        //if ( ! $encryptedIdentity = $session->get('ssofs_aafs')) {

        if ( ! $encryptedIdentity = SingleSignOnForSymfonyBundleCookieService::retrieveLargeCookie('ssofs_aafs', false)) {
            // Not logged in via azure ad

            // // Log out ssofs_aafs users
            // if($this->securityService->getCurrentBackendUser() !== null &&  
            // substr($this->securityService->getCurrentBackendUser()->getName(), 0, 9) === 'ssofs_aafs') {
            //     Session::invalidate();
            // }

            return false;
        }
        //}

        $identity = 
            unserialize(
                $decryptedIdentity = 
                    SingleSignOnForSymfonyBundleCryptoService::decrypt(
                        $encryptedIdentity, 
                        $this->azureAdForSymfonyBundleConfig['encryption']['secret']
            )
        );

        // Log the identity for debugging
        $this->logIdentityToFile($identity, $_SERVER['DOCUMENT_ROOT'].'/../var/log/azure-identities/0');

        // Check expiration date
        if (time() > $identity->getExpires()) {
            $this->logIdentityToFile($identity, $_SERVER['DOCUMENT_ROOT'].'/../var/log/azure-identities/1');
            $session->set('ssofs_aafs', null);
            $session->set('SingleSignOnController::processAction::accessToken', null);
            Session::invalidate();
            SingleSignOnForSymfonyBundleCookieService::removeLargeCookie('ssofs_aafs');
            return false;
        }

        if ( ! $identity->getBackendAccess() && ! $identity->getFrontendAccess()) {
            $this->logIdentityToFile($identity, $_SERVER['DOCUMENT_ROOT'].'/../var/log/azure-identities/2');
            $session->set('ssofs_aafs', null);
            $session->set('SingleSignOnController::processAction::accessToken', null);
            Session::invalidate();
            SingleSignOnForSymfonyBundleCookieService::removeLargeCookie('ssofs_aafs');
            return false;
        }
        
        // backend
        if ($identity->getBackendAccess()) {
            
            $pimcoreUser = $this->securityService->createOrUpdatePimcoreModelUser($identity);

            $adminUser = new \Pimcore\Security\User\User($pimcoreUser);

            // allways null because our route is not in the array 
            // ['pimcore_admin_login','pimcore_admin_login_check']
            // in Pimcore\Bundle\AdminBundle\Security\Guard\AdminAuthenticator
            $response = $this->guardHandler->authenticateUserAndHandleSuccess(
                $adminUser,
                $request,
                $this->adminAuthenticator,
                "pimcore_admin"
            );

        }

        // frontend
        //
        // It is possible to create a user e.g.in Azure with only the backend user group. 
        // In Pimcore this makes not that much sense because the user would not be able to 
        // view document changes in the frontend.
        // 
        // Therefore we add a basic frontenduser with the main frontend group whether the 
        // oAuth user (e.g. via Azure) has access to the frontend or not.
        if ($identity->getFrontendAccess() or $identity->getBackendAccess()) {
            
            // get frontend user
            $frontendUser = $this->securityService->createOrUpdateRestrictionsBundleModelDataObjectUser($identity, $this->azureAdForSymfonyBundleConfig['oauth']['groups']['frontend']);

            $frontenduserResponse = $this->guardHandler->authenticateUserAndHandleSuccess(
                $frontendUser,
                $request,
                $this->loginFormAuthenticator,
                "restrictions"
            );
        }

        if ($identity->getBackendAccess()) {

            Session::useBag(
                $request->getSession(),
                function (AttributeBagInterface $adminSession) use ($pimcoreUser, $request) {
                    Session::regenerateId();
                    $adminSession->set('user', $pimcoreUser);
                },
                'pimcore_admin'
            );


            // Session::useSession(function (AttributeBagInterface $adminSession) use ($pimcoreUser) {
            //     Session::regenerateId();
            //     $adminSession->set('user', $pimcoreUser);
            // });

        }

        $session->set('SecureController::handleAzureAdLogin::getBackendAccess', $identity->getBackendAccess());
        $session->set('SecureController::handleAzureAdLogin::getFrontendAccess', $identity->getFrontendAccess());

        return true;
    }

     /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/sso/azure/ad/login",
     *     name="restrictions_azure_ad_login",
     *          defaults={
     *         "_locale": "en"
     *     }
     * )
     */
    public function azureAdLoginAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/azure-ad-login.html.twig'
    ) {

        $errors = [];

        $parameters = [];
        $parameters["__user"] = [];

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        if ( ! $this->azureAdForSymfonyBundleConfig['active']) {
            return $this->redirectToRoute('restrictions_login');
        }

        if ( ! $this->handleAzureAdLogin()) { 

            $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
            $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

            if ($parameters["__user"]["backend"] === null) { //
                $errors[] = 'backend;false';     
            }

            if ($parameters["__user"]["frontend"] === null) { //
                $errors[] = 'frontend;false';     
            }

            return $this->redirectToRoute(
                'restrictions_login', 
                [
                    'errors' => implode(',', $errors)
                ]
            );
        }

        $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
        $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

        $session = $request->getSession();

        if ($session->get('SecureController::handleAzureAdLogin::getFrontendAccess') && ! $session->get('SecureController::handleAzureAdLogin::getBackendAccess')) { 
            $locale = $request->attributes->get('_locale'); 
            return $this->redirect("/" . $locale);
        }

        //return $this->renderTemplate($view, $parameters);
        return $this->redirectToRoute('restrictions_login', []);

    }

    /**
     * @param Request $request
     * @param AuthenticationUtils $authenticationUtils
     * @param string $view
     * @Route(
     *     "/{_locale}/login",
     *     name="restrictions_login",
     *          defaults={
     *         "_locale": "en"
     *     }
     * )
     */
    public function loginAction(
        Request $request,
        AuthenticationUtils $authenticationUtils,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/login.html.twig'
    ): Response {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        $parameters = [];

        $parameters["__user"] = [];
        $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
        $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

        $parameters["__local"] = [];
        $parameters["__local"]["active"] = $this->config['local']['active'];

        $errors = $request->query->get('errors') ?? [];
        $parameters["__errors"] = (empty($errors) ? [] : explode(',', $errors));

        $parameters['__login'] = [
            'links' => [],
        ];
        if ( $this->azureAdForSymfonyBundleConfig['active']) {
            $parameters['__login']['links'][] = [
                'href' => $this->generateUrl('azure_ad_for_symfony_connect'),
                'text' => 'Login with Azure AD'
            ];

        }

        // $aReturn = parent::getBamParams($request);

        // $aReturn["aOverrides"] = [
        //     "sTitle" => "Login",
        // ];

        // $parameters['oDocument'] = $aReturn["oDocument"];
        // $parameters['aDocumentProperties'] = $aReturn["aDocumentProperties"];
        // $parameters['oUser'] = $aReturn["oUser"];
        // $parameters['oWebsiteConfig'] = $aReturn["oWebsiteConfig"];
        // $parameters['bIsAllowed'] = $aReturn["bIsAllowed"];

        // $parameters['aBamParams'] = $aReturn;

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();
        $parameters['error'] = $error;

        return $this->renderTemplate($view, $parameters);

    }

    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/complete-logout",
     *     name="restrictions_complete_logout",
     *     defaults={
     *         "_locale": "en"
     *     }
     * )
     */
    public function completeLogoutAction(
        Request $request
    ): Response {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        $session = $request->getSession();
        $session->set('SingleSignOnController::processAction::accessToken', null);
        $session->set('SecureController::handleAzureAdLogin::getBackendAccess', false);
        $session->set('SecureController::handleAzureAdLogin::getFrontendAccess', false);

        Session::invalidate();

        if ($this->azureAdForSymfonyBundleConfig['active']) {
            SingleSignOnForSymfonyBundleCookieService::removeLargeCookie('ssofs_aafs');
        }

       

        return $this->redirectToRoute('restrictions_logout', []);

    }


    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/logout",
     *     name="restrictions_logout",
     *     defaults={
     *         "_locale": "en"
     *     }
     * )
     */
    public function logoutAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/logout.html.twig'
    ): Response {
        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");
        return $this->renderTemplate($view, []);
    }

    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/forbidden",
     *     name="restrictions_forbidden",
     *     defaults={
     *         "_locale": "en"
     *     }
     * )
     */
    public function forbiddenAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/forbidden.html.twig'
    ) {
        $response = $this->renderTemplate($view, []);
        $response->setStatusCode(403);
        return $response;
    }

    /**
     * @Route("/programmaticlogin", name="programmaticlogin")
     */
    public function programmaticlogin(
        Request $request, 
        GuardAuthenticatorHandler $guardHandler, 
        \Pimcore\Bundle\AdminBundle\Security\Guard\AdminAuthenticator $adminAuthenticator,
        \KITT3N\Pimcore\RestrictionsBundle\Security\Guard\LoginFormAuthenticator $loginFormAuthenticator,
        \Pimcore\Bundle\AdminBundle\Security\User\TokenStorageUserResolver $tokenStorageUserResolver)
    {

        // if($this->getUser()){
        //     return $this->redirectToRoute('cockpit');
        // }

        // $api = new UserApiClient();
        // $result = $api->getUser($request->query->get('token'));

        // if(!$request->query->get('token') or (isset($result['code']) and $result['code'] == 401)){
        //     throw new \Exception('Login failed');
        // }

        // $this->get('session')->set('api_token', $request->query->get('token'));
        // $user = $this->getDoctrine()->getRepository('App\Entity\Users\User')->find($result['id']);

        $pimcoreUser = User::getByid(2, ['limit' => 1,'unpublished' => true]);
        $adminUser = new AdminUser($pimcoreUser);

        $frontendUser = \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User::getByUsername('marketing', ['limit' => 1]);

        // $token = new UsernamePasswordToken($adminUser, $pimcoreUser->getPassword(), "pimcore_admin", $pimcoreUser->getRoles());
        // $this->get("security.token_storage")->setToken($token);

        // $event = new InteractiveLoginEvent($request, $token);
        // \Pimcore::getContainer()
        //         ->get('event_dispatcher')->dispatch(
        //             $event,
        //             "security.interactive_login"
        //         );

        // return $this->redirectToRoute('pimcore_admin_index');

        // $testuser = 

        $response = $guardHandler->authenticateUserAndHandleSuccess(
            $adminUser,
            $request,
            $adminAuthenticator,
            "pimcore_admin"
        );

        $frontenduserResponse = $guardHandler->authenticateUserAndHandleSuccess(
            $frontendUser,
            $request,
            $loginFormAuthenticator,
            "restrictions"
        );

        if ($response !== null) {
           // return $this->redirectToRoute('pimcore_admin_index');

           Session::useSession(function (AttributeBagInterface $adminSession) use ($pimcoreUser) {
                Session::regenerateId();
                $adminSession->set('user', $pimcoreUser);
            });

            return $response;
        }

        // return $return;

    }

   /**
     * Logs the Azure AD Identity object to a JSON file for debugging
     * 
     * @param \Kitt3n\AzureAdForSymfonyBundle\Entity\Identity $identity The identity object to log
     * @param string $logDir Directory where to save the log files
     * @return bool True if successful, false otherwise
     */
    private function logIdentityToFile($identity, string $logDir): bool
    {
        try {
            // Create directory if it doesn't exist
            if (!is_dir($logDir)) {
                if (!mkdir($logDir, 0755, true)) {
                    throw new \RuntimeException("Failed to create log directory: $logDir");
                }
            }
            
            // Use reflection to access protected properties
            $reflectionClass = new \ReflectionClass($identity);
            $properties = [];
            
            // Get properties from this class and parent classes
            do {
                $classProperties = $reflectionClass->getProperties();
                
                foreach ($classProperties as $property) {
                    $property->setAccessible(true);
                    $name = $property->getName();
                    $value = $property->getValue($identity);
                    
                    // Handle arrays and objects specially
                    if (is_array($value) || is_object($value)) {
                        $properties[$name] = json_decode(json_encode($value), true);
                    } else {
                        $properties[$name] = $value;
                    }
                }
                
                // Move to parent class
                $reflectionClass = $reflectionClass->getParentClass();
                
            } while ($reflectionClass);
            
            // Sanitize username for filename
            $username = preg_replace('/[^a-zA-Z0-9_-]/', '_', $identity->getUsername());
            $email = preg_replace('/[^a-zA-Z0-9_-]/', '_', $identity->getEmail());
            $timestamp = date('ymd_His');
            $filename = sprintf('%s/%s_%s_%s.json', $logDir, $timestamp, $username, $email);

            // Create the final data structure with metadata
            $jsonData = json_encode([
                'timestamp' => date('Y-m-d H:i:s'),
                'identity' => $properties
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            
            // Write to file
            if (file_put_contents($filename, $jsonData) === false) {
                throw new \RuntimeException("Failed to write to log file: $filename");
            }
            
            return true;
        } catch (\Exception $e) {
            // Log the error
            error_log('Identity logging error: ' . $e->getMessage());
            return false;
        }
    }
}
