#!/usr/bin/env bash

echo ""
echo "Install security providers configuration"
echo ""

cat ./vendor/kitt3n/pimcore-restrictions/src/KITT3N/Pimcore/RestrictionsBundle/Resources/install/config/packages/security_providers.txt

if grep -Fxq "# END security_providers.txt" ./config/packages/security.yaml
then
    
    echo ""
    echo "It seems as if the installation script has already been executed. Please check that."
    echo ""

else
    
    sed -i '/firewalls:$/i\ ' ./config/packages/security.yaml
    sed -i '/firewalls:$/i\# BEGIN security_providers.txt' ./config/packages/security.yaml
    sed -i '/firewalls:$/i\# END security_providers.txt' ./config/packages/security.yaml
    sed -i '/firewalls:$/i\ ' ./config/packages/security.yaml
    sed -i '/# END security_providers.txt/e cat ./vendor/kitt3n/pimcore-restrictions/src/KITT3N/Pimcore/RestrictionsBundle/Resources/install/config/packages/security_providers.txt' ./config/packages/security.yaml

    echo ""
    echo "Done."
    echo ""
    echo ""

fi

#!/usr/bin/env bash

echo ""
echo "Install security firewalls configuration"
echo ""

cat ./vendor/kitt3n/pimcore-restrictions/src/KITT3N/Pimcore/RestrictionsBundle/Resources/install/config/packages/security_firewalls.txt

if grep -Fxq "# END security_firewalls.txt" ./config/packages/security.yaml
then
    
    echo ""
    echo "It seems as if the installation script has already been executed. Please check that."
    echo ""

else
    
    sed -i '/access_control:$/i\ ' ./config/packages/security.yaml
    sed -i '/access_control:$/i\# BEGIN security_firewalls.txt' ./config/packages/security.yaml
    sed -i '/access_control:$/i\# END security_firewalls.txt' ./config/packages/security.yaml
    sed -i '/access_control:$/i\ ' ./config/packages/security.yaml
    sed -i '/# END security_firewalls.txt/e cat ./vendor/kitt3n/pimcore-restrictions/src/KITT3N/Pimcore/RestrictionsBundle/Resources/install/config/packages/security_firewalls.txt' ./config/packages/security.yaml

    echo ""
    echo "Done."
    echo ""
    echo ""

fi

echo ""
echo "Install security imports configuration"
echo ""

cat ./vendor/kitt3n/pimcore-restrictions/src/KITT3N/Pimcore/RestrictionsBundle/Resources/install/config/packages/security_imports.txt

if grep -Fxq "# END security_imports.txt" ./config/packages/security.yaml
then

    echo ""
    echo "It seems as if the installation script has already been executed. Please check that."
    echo ""

else

    sed -i '/imports:$/a\# END security_imports.txt' ./config/packages/security.yaml
    sed -i '/imports:$/a\# BEGIN security_imports.txt' ./config/packages/security.yaml
    sed -i '/# END security_imports.txt/e cat ./vendor/kitt3n/pimcore-restrictions/src/KITT3N/Pimcore/RestrictionsBundle/Resources/install/config/packages/security_imports.txt' ./config/packages/security.yaml

    echo ""
    echo "Done."
    echo ""
    echo ""

fi
