<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Twig\Extension;

use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class CacheKeyExtension extends AbstractExtension
{
    /**
     * @var TokenStorageInterface
     */
    protected $tokenStorage;

    /**
     * @var SecurityService
     */
    protected $securityService;

    public function __construct(
        TokenStorageInterface $tokenStorage,
        SecurityService $securityService
    ) {
        $this->tokenStorage = $tokenStorage;
        $this->securityService = $securityService;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('restrictions_cache_key', [$this, 'getCacheKey']),
        ];
    }

    public function getCacheKey()
    {
        $context = $this->securityService->getContext();

        if ($context === 'backend') {
            //return 'backend';
            return rand(1111111111,9999999999);
        }

        /* @var \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User|null $currentUser */
        $currentUser = $this->securityService->getCurrentUser();

        if ($currentUser instanceof \KITT3N\Pimcore\RestrictionsBundle\Model\DataObject\User) {
            return $currentUser->getId();
        }

    }
}

