<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Twig\Extension;

use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class IsUserAllowedToAccessDocumentExtension extends AbstractExtension
{
    /**
     * @var SecurityService
     */
    protected $securityService;

    public function __construct(
        SecurityService $securityService
    ) {
        $this->securityService = $securityService;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('restrictions_isUserAllowedToAccessDocument', [$this, 'isUserAllowedToAccessDocument']),
        ];
    }

    public function isUserAllowedToAccessDocument(\Pimcore\Model\Document $document)
    {
        return $this->securityService->isUserAllowedToAccessDocument($document);

    }
}

