<?php
declare(strict_types=1);

namespace KITT3N\Pimcore\RestrictionsBundle;

use Composer\Script\Event;

/**
 * @internal
 */
class Composer extends \Pimcore\Composer
{

    /**
     * @param Event $event
     */
    public static function installClasses(Event $event): void
    {

        $consoleDir = static::getConsoleDir($event, 'install kitt3n_pimcore_restrictions classes');

        if (null === $consoleDir) {
            return;
        }

        $command = [
            'kitt3n_pimcore_restrictions:install:classes',
            '--no-interaction'
        ];

        try {
            $event->getIO()->write('<comment>Perform command ' .  implode(" ", $command) . '</comment>');
            static::executeCommand($event, $consoleDir, $command);
        } catch (\Throwable $e) {
            $event->getIO()->write('<comment>Unable to perform command ' .  implode(" ", $command) . '</comment>');
        }

    }
    
}
