<?php

namespace KITT3N\Pimcore\RestrictionsBundle\Controller;

use KITT3N\Pimcore\RestrictionsBundle\Controller\Interfaces\RestrictionsBundleControllerInterface;
use KITT3N\Pimcore\RestrictionsBundle\Form\LoginFormType;

use Pimcore\Config;
use Pimcore\Controller\FrontendController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Routing\Annotation\Route;

use Pimcore\Model\User;
use Pimcore\Bundle\AdminBundle\Security\User\User as AdminUser;
use Symfony\Component\Security\Http\Authentication\UserAuthenticatorInterface;

use Symfony\Component\HttpFoundation\Session\Attribute\AttributeBagInterface;
use Pimcore\Tool\Session;

use Kitt3n\AzureAdForSymfonyBundle\Service\ConfigService as AzureAdForSymfonyBundleConfigService;
use Kitt3n\AzureAdForSymfonyBundle\Entity\Identity as AzureAdForSymfonyBundleIdentity;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CryptoService as SingleSignOnForSymfonyBundleCryptoService;
use Kitt3n\SingleSignOnForSymfonyBundle\Service\CookieService as SingleSignOnForSymfonyBundleCookieService;
use Symfony\Component\HttpFoundation\RequestStack;
use Pimcore\Model\User\UserRole;
use Pimcore\Model\User\Role;
use Pimcore\Tool\Admin;

use KITT3N\Pimcore\RestrictionsBundle\Service\ConfigService;
use KITT3N\Pimcore\RestrictionsBundle\Service\SecurityService;

use Pimcore\Bundle\CoreBundle\EventListener\Frontend\FullPageCacheListener;

use Symfony\Bundle\SecurityBundle\Security;

class SecureController extends FrontendController //extends \KITT3N\Pimcore\LayoutsBundle\Controller\DefaultController
{
    private $azureAdForSymfonyBundleConfigService;

    private $azureAdForSymfonyBundleConfig;

    protected $configService;
    protected $config;

    protected $security;

    private $requestStack;

    protected $userAuthenticator;

    private $tokenStorageUserResolver;

    private $securityService;

    protected $fullPageCacheListener;

    public function __construct(
        RequestStack $requestStack,
        AzureAdForSymfonyBundleConfigService $azureAdForSymfonyBundleConfigService,
        ConfigService $configService,

        UserAuthenticatorInterface $userAuthenticator, 
        // \Pimcore\Bundle\AdminBundle\Security\User\TokenStorageUserResolver $tokenStorageUserResolver,

        SecurityService $securityService,
        Security $security,

        FullPageCacheListener $fullPageCacheListener
    ) {
        $this->requestStack = $requestStack;
        $this->azureAdForSymfonyBundleConfigService = $azureAdForSymfonyBundleConfigService;
        $this->azureAdForSymfonyBundleConfig = $this->azureAdForSymfonyBundleConfigService->getConfig();

        $this->configService = $configService;
        $this->config = $this->configService->getConfig();

        $this->userAuthenticator = $userAuthenticator;

        // $this->tokenStorageUserResolver = $tokenStorageUserResolver;

        $this->securityService = $securityService;
        $this->security = $security;

        $this->fullPageCacheListener = $fullPageCacheListener;

    }

    protected function getBackendLink(): ?string
    {
        if ( ! $encryptedIdentity = SingleSignOnForSymfonyBundleCookieService::retrieveLargeCookie('ssofs_aafs', false)) {
            // Not logged in via azure ad
            return null;
        }

        $identity = 
            unserialize(
                $decryptedIdentity = 
                    SingleSignOnForSymfonyBundleCryptoService::decrypt(
                        $encryptedIdentity, 
                        $this->azureAdForSymfonyBundleConfig['encryption']['secret']
            )
        );

        if ( ! $identity->getBackendAccess()) {
            return null;
        }

        return $this->securityService->generateBackendLink($identity);
    }

    protected function handleAzureAdLogin() {
        
        $request = $this->requestStack->getCurrentRequest();
        $session = $request->getSession();

        if ( ! $encryptedIdentity = SingleSignOnForSymfonyBundleCookieService::retrieveLargeCookie('ssofs_aafs', false)) {
            
            // Not logged in via azure ad
            return false;

        }

        $identity = 
            unserialize(
                $decryptedIdentity = 
                    SingleSignOnForSymfonyBundleCryptoService::decrypt(
                        $encryptedIdentity, 
                        $this->azureAdForSymfonyBundleConfig['encryption']['secret']
            )
        );

        // Check expiration date
        if (time() > $identity->getExpires()) {
            $session->set('ssofs_aafs', null);
            $session->set('SingleSignOnController::processAction::accessToken', null);
            //Session::invalidate();
            SingleSignOnForSymfonyBundleCookieService::removeLargeCookie('ssofs_aafs');
            return false;
        }

        if ( ! $identity->getBackendAccess() && ! $identity->getFrontendAccess()) {
            $session->set('ssofs_aafs', null);
            $session->set('SingleSignOnController::processAction::accessToken', null);
            //Session::invalidate();
            SingleSignOnForSymfonyBundleCookieService::removeLargeCookie('ssofs_aafs');
            return false;
        }
        
        // backend
        if ($identity->getBackendAccess()) {
            
            $pimcoreUser = $this->securityService->createOrUpdatePimcoreModelUser($identity);

        }

        // frontend
        //
        // It is possible to create a user e.g.in Azure with only the backend user group. 
        // In Pimcore this makes not that much sense because the user would not be able to 
        // view document changes in the frontend.
        // 
        // Therefore we add a basic frontenduser with the main frontend group whether the 
        // oAuth user (e.g. via Azure) has access to the frontend or not.
        if ($identity->getFrontendAccess() or $identity->getBackendAccess()) {
            
            // get frontend user
            $frontendUser = $this->securityService->createOrUpdateRestrictionsBundleModelDataObjectUser($identity, $this->azureAdForSymfonyBundleConfig['oauth']['groups']['frontend']);

            // log the user in on the current firewall
            $this->security->login($frontendUser, "security.authenticator.form_login.restrictions");

        }

        $session->set('SecureController::handleAzureAdLogin::getBackendAccess', $identity->getBackendAccess());
        $session->set('SecureController::handleAzureAdLogin::getFrontendAccess', $identity->getFrontendAccess());

        return true;
    }

     /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/sso/azure/ad/login{trailing}",
     *     name="restrictions_azure_ad_login",
     *          defaults={
     *         "_locale": "en",
     *         "trailing": ""
     *     },
     *     requirements={
     *         "trailing": "^\/?$"
     *     }
     * )
     */
    public function azureAdLoginAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/azure-ad-login.html.twig'
    ) {

        $errors = [];

        $parameters = [];
        $parameters["__user"] = [];

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        if ( ! $this->azureAdForSymfonyBundleConfig['active']) {
            return $this->redirectToRoute('restrictions_login');
        }

        if ( ! $this->handleAzureAdLogin()) { 

            $parameters["__backendLink"] = $this->getBackendLink();
            $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
            $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

            if ($parameters["__user"]["backend"] === null) { //
                $errors[] = 'backend;false';     
            }

            if ($parameters["__user"]["frontend"] === null) { //
                $errors[] = 'frontend;false';     
            }

            return $this->redirectToRoute(
                'restrictions_login', 
                [
                    'errors' => implode(',', $errors)
                ]
            );
        }

        $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
        $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

        $session = $request->getSession();

        if ($session->get('SecureController::handleAzureAdLogin::getFrontendAccess') && ! $session->get('SecureController::handleAzureAdLogin::getBackendAccess')) { 
            $locale = $request->attributes->get('_locale'); 
            return $this->redirect("/" . $locale);
        }

        //return $this->renderTemplate($view, $parameters);
        return $this->redirectToRoute('restrictions_login', []);

    }

    /**
     * @param Request $request
     * @param AuthenticationUtils $authenticationUtils
     * @param string $view
     * @Route(
     *     "/{_locale}/login{trailing}",
     *     name="restrictions_login",
     *          defaults={
     *         "_locale": "en",
     *         "trailing": ""
     *     },
     *     requirements={
     *         "trailing": "^\/?$"
     *     }
     * )
     */
    public function loginAction(
        Request $request,
        AuthenticationUtils $authenticationUtils,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/login.html.twig'
    ): Response {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        $parameters = [];

        $parameters["__backendLink"] = $this->getBackendLink();

        $parameters["__user"] = [];
        $parameters["__user"]["backend"] = $this->securityService->getCurrentBackendUser();
        $parameters["__user"]["frontend"] = $this->securityService->getCurrentUser();

        $parameters["__local"] = [];
        $parameters["__local"]["active"] = $this->config['local']['active'];

        $errors = $request->query->get('errors') ?? [];
        $parameters["__errors"] = (empty($errors) ? [] : explode(',', $errors));

        $parameters['__login'] = [
            'links' => [],
        ];
        if ( $this->azureAdForSymfonyBundleConfig['active']) {
            $parameters['__login']['links'][] = [
                'href' => $this->generateUrl('azure_ad_for_symfony_connect'),
                'text' => 'Login with Azure AD'
            ];

        }

        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();
        $parameters['last_username'] = $lastUsername;

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();
        $parameters['error'] = $error;

        return $this->renderTemplate($view, $parameters);

    }

    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/complete-logout{trailing}",
     *     name="restrictions_complete_logout",
     *     defaults={
     *         "_locale": "en",
     *         "trailing": ""
     *     },
     *     requirements={
     *         "trailing": "^\/?$"
     *     }
     * )
     */
    public function completeLogoutAction(
        Request $request
    ): Response {

        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");

        $session = $request->getSession();
        $session->set('SingleSignOnController::processAction::accessToken', null);
        $session->set('SecureController::handleAzureAdLogin::getBackendAccess', false);
        $session->set('SecureController::handleAzureAdLogin::getFrontendAccess', false);

        $session->set('_security_pimcore_admin', null);

        if ($this->azureAdForSymfonyBundleConfig['active']) {
            SingleSignOnForSymfonyBundleCookieService::removeLargeCookie('ssofs_aafs');
        }

        return $this->redirectToRoute('restrictions_logout', []);

    }


    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/logout{trailing}",
     *     name="restrictions_logout",
     *     defaults={
     *         "_locale": "en",
     *         "trailing": ""
     *     },
     *     requirements={
     *         "trailing": "^\/?$"
     *     }
     * )
     */
    public function logoutAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/logout.html.twig'
    ): Response {
        $this->fullPageCacheListener->disable("Nom nom nom, Cookies, Restrictions, ...");
        return $this->renderTemplate($view, []);
    }

    /**
     * @param Request $request
     * @param string $view
     * @Route(
     *     "/{_locale}/forbidden{trailing}",
     *     name="restrictions_forbidden",
     *     defaults={
     *         "_locale": "en",
     *         "trailing": ""
     *     },
     *     requirements={
     *         "trailing": "^\/?$"
     *     }
     * )
     */
    public function forbiddenAction(
        Request $request,
        string $view = '@Kitt3nPimcoreRestrictionsBundle/secure/forbidden.html.twig'
    ) {
        $response = $this->renderTemplate($view, []);
        $response->setStatusCode(403);
        return $response;
    }

}
