<?php 

namespace Kitt3n\SingleSignOnForSymfonyBundle\Service;

use Kitt3n\SingleSignOnForSymfonyBundle\Service\CryptoService;

class CookieService
{
    
    protected static $cookieSplitLength = 1000;

	/**
	 * 
	 * @return mixed
	 */
	public static function getCookieSplitLength() 
    {
		return self::$cookieSplitLength;
	}
	
	/**
	 * 
	 * @param mixed $cookieSplitLength 
	 */
	public static function setCookieSplitLength($cookieSplitLength)
    {
		self::$cookieSplitLength = $cookieSplitLength;
	}

    public static function saveLargeCookie($name, $value, $expires, $path, $encrypt = false, $key = null) 
    {
    
        if($encrypt) {

            if(!isset($key)) {
                return false;
            }

            $value = CryptoService::encrypt(
                message: $value,
                key: $key
            );
        }

        $split = str_split($value , self::getCookieSplitLength());
        $count = count( $split );

        $return = [];
        for ( $index = 0 ; $index < $count; $index++ ) {
            $return[] = setcookie( 
                $name . '_' . $index, 
                $split[$index],
                [
                    'expires' => $expires,
                    'secure' => true,
                    'httponly' => true,
                    'path' => $path,
                    'samesite' => 'Lax'
                ] 
            );
        }
        $return[] = setcookie( 
            $name, 
            $count, 
            [
                'expires' => $expires,
                'secure' => true,
                'httponly' => true,
                'path' => $path,
                'samesite' => 'Lax'
            ]  
        );

        if(in_array(needle: false, haystack: $return)) { 
            return false;
        }

        return true;
        
    }

    public static function removeLargeCookie($name) { 
        
        if (!isset($_COOKIE[$name])) {
            return;
        }

        $count = (int) $_COOKIE[$name];
        for ( $index = 0 ; $index < $count; $index++ ) {
            if (isset($_COOKIE[$name . '_' . $index])) {
                unset($_COOKIE[$name . '_' . $index]); 
                setcookie($name . '_' . $index, null, -1, '/'); 
            }
        }
        unset($_COOKIE[$name]); 
        setcookie($name, null, -1, '/');

    }

    public static function retrieveLargeCookie($name, $encrypted = false, $key = null) 
    { 
        
        if (!isset($_COOKIE[$name])) {
            return false;
        }

        $values = [];
        $count = (int) $_COOKIE[$name];
        for ( $index = 0 ; $index < $count; $index++ ) {
            
            if (!isset($_COOKIE[$name . '_' . $index])) {
                
                return false;

            }

            $values[] = $_COOKIE[$name . '_' . $index];

        }

        $value = implode('', $values);

        if (!$encrypted) {
            return $value;
        }     
        
        if(!isset($key)) {
            return false;
        }

        $decrypted_value = CryptoService::decrypt(
            message: $value,
            key: $key
        );

        return $decrypted_value;

    }

}