<?php 

namespace Kitt3n\SingleSignOnForSymfonyBundle\Service;

use League\OAuth2\Client\Provider\GenericProvider;

use Kitt3n\SingleSignOnForSymfonyBundle\Service\ConfigService;

use Symfony\Component\HttpFoundation\RequestStack;

class OauthService
{
    protected $requestStack;
    private $configService = null;

    public function __construct(
        RequestStack $requestStack,
        ConfigService $configService
    ) {
        $this->requestStack = $requestStack;
        $this->configService = $configService;
    }
    
    public function getOauthClient(
        string $clientId,
        string $clientSecret,
        string $tenant,
        string $redirectUri,
        string $urlAuthorize,
        string $urlAccessToken,
        string $urlResourceOwnerDetails,
        string $scopes
    ): GenericProvider
    {

        $request = $this->requestStack->getCurrentRequest();
        $locale = $request->getLocale();
        $httpHost = $request->getHttpHost();
        
        // Initialize the OAuth client
        $oauthClient = new GenericProvider([
            'clientId'                => $clientId,
            'clientSecret'            => $clientSecret,
            'tenant'                  => $tenant,
            'redirectUri'             => str_replace(['[[[_http_host]]]', '[[[_locale]]]'], [$httpHost, $locale], $redirectUri),
            'urlAuthorize'            => $urlAuthorize,
            'urlAccessToken'          => $urlAccessToken,
            'urlResourceOwnerDetails' => $urlResourceOwnerDetails,
            'scopes'                  => $scopes,
        ]);

        return $oauthClient;

    }

}