<?php

namespace Kitt3n\SingleSignOnForSymfonyBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class SingleSignOnForSymfonyExtension extends Extension implements PrependExtensionInterface
{

    // public function prepend(ContainerBuilder $container): void
    // {
    //     // Add the bundle's templates with LOWER priority
    //     // Note: NOT using prependExtensionConfig which would give it HIGHER priority
    //     if ($container->hasExtension('twig')) {
    //         $container->loadFromExtension('twig', [
    //             'paths' => [
    //                 '%kernel.project_dir%/vendor/kitt3n/single-sign-on-for-symfony/src/templates' => 'SingleSignOnForSymfonyBundle'
    //             ]
    //         ]);
    //     }
    // }

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../../config'));
        $loader->load('services.yaml');
        
        $container->setParameter( 'single_sign_on_for_symfony', $config);
    }
}
