<?php

namespace Kitt3n\SingleSignOnForSymfonyBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('single_sign_on_for_symfony');
        $rootNode = $treeBuilder->getRootNode();

        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.

        $rootNode
            ->children()

                ->arrayNode('oauth')
                    ->addDefaultsIfNotSet()
                    ->children()
                    ->scalarNode('client_id')->defaultValue('%env(resolve:SSOFS_OAUTH_CLIENT_ID)%')->end()
                    ->scalarNode('client_secret')->defaultValue('%env(resolve:SSOFS_OAUTH_CLIENT_SECRET)%')->end()
                    ->scalarNode('tenant')->defaultValue('%env(resolve:SSOFS_OAUTH_TENANT)%')->end()
                    ->scalarNode('redirect_uri')->defaultValue('%env(resolve:SSOFS_OAUTH_REDIRECT_URI_DOMAIN)%/[[[_locale]]]/sso/generic/process')->end()
                    ->scalarNode('url_authorize')->defaultValue('https://login.microsoftonline.com/%env(resolve:SSOFS_OAUTH_TENANT)%/oauth2/v2.0/authorize')->end()
                    ->scalarNode('url_access_token')->defaultValue('https://login.microsoftonline.com/%env(resolve:SSOFS_OAUTH_TENANT)%/oauth2/v2.0/token')->end()
                    ->scalarNode('url_resource_owner_details')->defaultValue('')->end()
                    ->scalarNode('scopes')->defaultValue('%env(resolve:SSOFS_OAUTH_SCOPES)%')->end()

                    ->end()
                ->end()

                ->arrayNode('encryption')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('secret')->defaultValue('%env(resolve:SSOFS_ENCRYPTION_SECRET)%')->end()
                    ->end()
                ->end()

                ->arrayNode('handlers')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('session')->isRequired()->defaultValue('%env(resolve:SSOFS_HANDLERS_SESSION)%')->end()
                        ->booleanNode('cookie')->isRequired()->defaultValue('%env(resolve:SSOFS_HANDLERS_COOKIE)%')->end()
                    ->end()
                ->end()

            ->end()
            ;

        return $treeBuilder;
    }
}
