<?php

namespace ZWEI14\Captcha\Service;

use ZWEI14\Captcha\Interfaces\Options;

/***
 *
 * This file is part of the "zwei14_captcha" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018
 *
 ***/

/**
 * Class ValidationService
 * @package ZWEI14\Captcha\Service
 */
class ValidationService implements \TYPO3\CMS\Core\SingletonInterface
{

    public function returnErrorMessage(array $z14c)
    {

        $errorMessage = '--';

        if ($z14c === null) {
            $errorMessage = 
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'validator.notempty.null',
                    'extbase'
                );
            return $errorMessage;
        }
        if ($z14c === '') {
            $errorMessage =
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'validator.notempty.empty',
                    'extbase'
                );
            return $errorMessage;
        }
        if (is_array($z14c) && empty($z14c)) {
            $errorMessage =
               \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'validator.notempty.empty',
                    'extbase'
                );
            return $errorMessage;
        }
        if (is_object($z14c) && $z14c instanceof \Countable && $z14c->count() === 0) {
            $errorMessage =
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'validator.notempty.empty',
                    'extbase'
                );
            return $errorMessage;
        }

        if (is_array($z14c) && (count($z14c) === 0 || count($z14c) === 1)) {
            $errorMessage =
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'validator.notempty.empty',
                    'extbase'
                );
            return $errorMessage;
        }

        if (is_array($z14c) && ! array_key_exists($z14c[0], Options::OPTIONS)) {
            $errorMessage =
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.value.0.error',
                'zwei14_captcha'
            );
            return $errorMessage;
        }

        $validOptions = Options::OPTIONS[$z14c[0]];
        unset($z14c[0]);

        if (is_array($z14c) && count($z14c) < 3) {
            $errorMessage = 
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.not.enough',
                    'zwei14_captcha'
                );
            return $errorMessage;
        }

        if (is_array($z14c) && count($z14c) > 4) {
            $errorMessage = 
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.too.many',
                    'zwei14_captcha'
                );
            return $errorMessage;
        }

        $diff = array_diff($z14c, $validOptions);

        if (! empty($diff)) {     
            $errorMessage = 
                \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate(
                    'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.value.any.error',
                    'zwei14_captcha'
                );
            return $errorMessage;
        }

        return $errorMessage;
    }

}