<?php
namespace ZWEI14\Captcha\Validation\Validator;

use ZWEI14\Captcha\Interfaces\Options;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

/**
 * Validator based on regular expressions.
 */
class CaptchaValidator extends \TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator implements Options
{
    /**
     * This validator always needs to be executed even if the given value is empty.
     * See AbstractValidator::validate()
     *
     * @var bool
     */
    protected $acceptsEmptyValues = false;

    /**
     * @var array
     */
    protected $supportedOptions = [
        // 'validOptions' => ['', 'The regular expression to use for validation, used as given', 'string', true]
    ];

    /**
     * Checks if the given value matches the specified regular expression.
     *
     * @param mixed $value The value that should be validated
     * @throws \TYPO3\CMS\Extbase\Validation\Exception\InvalidValidationOptionsException
     */
    public function isValid(mixed $value): void
    {
        if ($value === null) {
            $this->addError(
                $this->translateErrorMessage(
                    'validator.notempty.null',
                    'extbase'
                ),
                1221560910
            );
            return;
        }
        if ($value === '') {
            $this->addError(
                $this->translateErrorMessage(
                    'validator.notempty.empty',
                    'extbase'
                ),
                1221560718
            );
            return;
        }
        if (is_array($value) && empty($value)) {
            $this->addError(
                $this->translateErrorMessage(
                    'validator.notempty.empty',
                    'extbase'
                ),
                1347992400
            );
            return;
        }
        if (is_object($value) && $value instanceof \Countable && $value->count() === 0) {
            $this->addError(
                $this->translateErrorMessage(
                    'validator.notempty.empty',
                    'extbase'
                ),
                1347992453
            );
            return;
        }

        if (is_array($value) && (count($value) === 0 || count($value) === 1)) {
            $this->addError(
                $this->translateErrorMessage(
                    'validator.notempty.empty',
                    'extbase'
                ),
                1347992453
            );
            return;
        }

        if (is_array($value) && ! array_key_exists($value[0], Options::OPTIONS)) {
            $this->addError(
                $this->translateErrorMessage(
                'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.value.0.error',
                'zwei14_captcha'
            ),
                1000000020
            );
            return;
        }

        $validOptions = Options::OPTIONS[$value[0]];
        unset($value[0]);

        if (is_array($value) && count($value) < 3) {
            $this->addError(
                $errorMessage = $this->translateErrorMessage(
                    'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.not.enough',
                    'zwei14_captcha'
                ) ?? '1000000000: validator.captcha.not.enough',
                1000000000
            );
            return;
        }

        if (is_array($value) && count($value) > 4) {
            $this->addError(
                $errorMessage = $this->translateErrorMessage(
                    'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.too.many',
                    'zwei14_captcha'
                ) ?? '1000000010: validator.captcha.too.many',
                1000000010
            );
            return;
        }

        $diff = array_diff($value, $validOptions);

        if (! empty($diff)) {     
            $this->addError(
                $errorMessage = $this->translateErrorMessage(
                    'LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:validator.captcha.value.any.error',
                    'zwei14_captcha'
                ) ?? '1000000002: validator.captcha.value.any.error',
                1000000002
            );
            return;
        }

        return;
        
    }
}
