<?php
namespace ZWEI14\Captcha\ViewHelpers;

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\PathUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;
use ZWEI14\Captcha\Interfaces\Options;
use Gregwar\Captcha\CaptchaBuilder;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

use Symfony\Component\Filesystem\Filesystem;

final class CaptchaViewHelper extends AbstractViewHelper implements Options
{
    use CompileWithRenderStatic;

    protected $escapeOutput = false;

    private static $projectPath = "";

    private static $publicPath = "";

    private static $imagePath = "";

    public function initializeArguments()
    {
        // registerArgument($name, $type, $description, $required, $defaultValue, $escape)
        // $this->registerArgument('emailAddress', 'string', 'The email address to resolve the gravatar for', true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
        )
    {

        switch (true) {
            case (int)(explode(".", \TYPO3\CMS\Core\Utility\VersionNumberUtility::getCurrentTypo3Version())[0]) === 8:
                self::$projectPath = $_ENV['TYPO3_PATH_APP'];
                break;
            default: 
            // TYPO3 9 or above
            self::$projectPath = \TYPO3\CMS\Core\Core\Environment::getProjectPath();
            self::$publicPath = \TYPO3\CMS\Core\Core\Environment::getPublicPath();
            self::$imagePath = PathUtility::getAbsoluteWebPath(
                ExtensionManagementUtility::extPath('zwei14_captcha') . 'Resources/Public/Images'
            ); 
        }
        
        $validOptionKey = array_rand(($all = Options::OPTIONS));
        $readableValidOptionKey = 
            LocalizationUtility::translate('LLL:EXT:zwei14_captcha/Resources/Private/Language/translation.xlf:OPTIONS.' .$validOptionKey,'zwei14_captcha');
        $validOptions = $all[$validOptionKey];

        $filesystem = new Filesystem();
        $file = self::$projectPath . '/vendor/zwei14/captcha/Resources/Public/Images/hint/' . base64_encode($readableValidOptionKey) . '.txt';
        if (! $filesystem->exists($file)) { 

            $captcha = new CaptchaBuilder($readableValidOptionKey);
            $captcha->setMaxFrontLines(0);
            $captcha->setMaxBehindLines(0);
            $captcha->setTextColor(10,10,10);
            $captcha->setBackgroundColor(255,255,255);
            $build = $captcha->build(17*strlen($readableValidOptionKey), 40, self::$projectPath . '/vendor/gregwar/captcha/src/Gregwar/Captcha/Font/captcha3.ttf');
            
            $hint = $captcha->inline();
            $filesystem->dumpFile($file, $hint);

        } else { 

            $hint = file_get_contents($file);
            
        }

        $options = array_merge(
            //Options::AIRPLANES, 
            Options::BRUSHES, 
            Options::MOONS, 
            Options::PENCILS, 
            Options::PHONES
        );
        
        // this is improved with the TagBasedViewHelper (see below)
        shuffle($options);
        return [
            'imagePath' => self::$imagePath,
            'options' => $options,
            'validOptionKey' => $validOptionKey,
            'readableValidOptionKey' => $readableValidOptionKey,
            'validOptions' => $validOptions,

            'hint' => $hint
        ];
    }

    public static function shuffle_assoc($list) { 
        if (!is_array($list)) return $list; 
      
        $keys = array_keys($list); 
        shuffle($keys); 
        $random = array(); 
        foreach ($keys as $key) { 
          $random[$key] = $list[$key]; 
        }
        return $random; 
      } 
}